/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.pojo;

import dev.morphia.annotations.PostPersist;
import dev.morphia.annotations.PrePersist;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.EntityEncoder;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.MorphiaCodec;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.EncoderContext;

public class LifecycleEncoder
extends EntityEncoder {
    public <T> LifecycleEncoder(MorphiaCodec<T> morphiaCodec) {
        super(morphiaCodec);
    }

    @Override
    public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
        EntityModel model = this.getMorphiaCodec().getEntityModel();
        Mapper mapper = this.getMorphiaCodec().getMapper();
        Document document = new Document();
        model.callLifecycleMethods(PrePersist.class, value, document, mapper);
        DocumentWriter documentWriter = new DocumentWriter(mapper, document);
        super.encode((BsonWriter)documentWriter, value, encoderContext);
        document = documentWriter.getDocument();
        model.callLifecycleMethods(PostPersist.class, value, document, mapper);
        this.getMorphiaCodec().getRegistry().get(Document.class).encode(writer, document, encoderContext);
    }
}

