/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.pojo;

import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.annotations.Entity;
import dev.morphia.mapping.NotMappableException;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.codec.pojo.PropertyModelBuilder;
import dev.morphia.mapping.codec.pojo.TypeData;
import dev.morphia.mapping.conventions.MorphiaConvention;
import dev.morphia.sofia.Sofia;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class EntityModelBuilder {
    private final Datastore datastore;
    private final List<PropertyModelBuilder> propertyModels = new ArrayList<PropertyModelBuilder>();
    private final Class<?> type;
    private final Map<Class<? extends Annotation>, Annotation> annotationsMap = new HashMap<Class<? extends Annotation>, Annotation>();
    private final Set<Class<?>> classes = new LinkedHashSet();
    private final Set<Class<?>> interfaces = new LinkedHashSet();
    private final Set<Annotation> annotations = new LinkedHashSet<Annotation>();
    private boolean discriminatorEnabled;
    private String discriminator;
    private String discriminatorKey;
    private String idPropertyName;
    private String versionPropertyName;
    private final List<EntityModel> interfaceModels;
    private EntityModel superclass;
    private final Map<String, Map<String, Type>> parameterization;

    public EntityModelBuilder(Datastore datastore, Class<?> type2) {
        this.datastore = datastore;
        this.type = type2;
        this.buildHierarchy(this.type);
        this.parameterization = this.findParameterization(type2);
        this.propagateTypes();
        if (type2.getSuperclass() != null) {
            try {
                this.superclass = datastore.getMapper().getEntityModel(type2.getSuperclass());
            }
            catch (NotMappableException notMappableException) {
                // empty catch block
            }
        }
        this.interfaceModels = this.interfaces.stream().map(i2 -> {
            try {
                return datastore.getMapper().getEntityModel((Class)i2);
            }
            catch (NotMappableException ignored) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public <T, A extends Annotation> EntityModelBuilder(Datastore datastore, A annotation, Class<T> clazz) {
        this(datastore, clazz);
        LinkedHashSet<Annotation> temp = new LinkedHashSet<Annotation>();
        temp.add(annotation);
        temp.addAll(this.annotations);
        this.annotations.clear();
        this.annotations.addAll(temp);
    }

    public PropertyModelBuilder addProperty() {
        PropertyModelBuilder builder = PropertyModel.builder(this.datastore);
        this.propertyModels.add(builder);
        return builder;
    }

    public Set<Class<?>> classHierarchy() {
        return this.classes;
    }

    private Map<String, Map<String, Type>> findParameterization(Class<?> type2) {
        if (type2.getSuperclass() == null) {
            return new LinkedHashMap<String, Map<String, Type>>();
        }
        Map<String, Map<String, Type>> parentMap = this.findParameterization(type2.getSuperclass());
        Map<String, Type> typeMap = this.mapArguments(type2.getSuperclass(), type2.getGenericSuperclass());
        parentMap.put(type2.getSuperclass().getName(), typeMap);
        return parentMap;
    }

    @Nullable
    public <A extends Annotation> A getAnnotation(Class<A> type2) {
        return (A)this.annotationsMap.get(type2);
    }

    private Set<Class<?>> findParentClasses(Class<?> type2) {
        LinkedHashSet classes = new LinkedHashSet();
        while (type2 != null && !type2.isEnum() && !type2.equals(Object.class)) {
            classes.add(type2);
            this.annotations.addAll(Set.of(type2.getAnnotations()));
            type2 = type2.getSuperclass();
        }
        return classes;
    }

    public Set<Annotation> annotations() {
        return this.annotations;
    }

    public EntityModel build() {
        this.annotations.forEach(a -> this.annotationsMap.putIfAbsent(a.annotationType(), (Annotation)a));
        for (MorphiaConvention convention : this.datastore.getMapper().getOptions().getConventions()) {
            convention.apply(this.datastore, this);
        }
        if (this.discriminatorEnabled) {
            Objects.requireNonNull(this.discriminatorKey, Sofia.notNull("discriminatorKey", new Locale[0]));
            Objects.requireNonNull(this.discriminator, Sofia.notNull("discriminator", new Locale[0]));
        }
        return new EntityModel(this);
    }

    public EntityModelBuilder discriminator(String discriminator) {
        this.discriminator = discriminator;
        return this;
    }

    public String discriminator() {
        return this.discriminator;
    }

    public EntityModelBuilder discriminatorKey(String key) {
        this.discriminatorKey = key;
        return this;
    }

    public String discriminatorKey() {
        return this.discriminatorKey;
    }

    public EntityModelBuilder enableDiscriminator(boolean enabled) {
        this.discriminatorEnabled = enabled;
        return this;
    }

    @Nullable
    public String idPropertyName() {
        return this.idPropertyName;
    }

    public EntityModelBuilder idPropertyName(String name) {
        this.idPropertyName = name;
        return this;
    }

    @Nullable
    public EntityModel superclass() {
        return this.superclass;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean hasAnnotation(Class<? extends Annotation> type2) {
        for (Annotation annotation : this.annotations) {
            if (!type2.equals(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    public PropertyModelBuilder propertyModelByName(String name) throws NoSuchElementException {
        return this.propertyModels.stream().filter(f -> f.name().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No property found named %s.  Valid names are: %s", name, this.propertyModels.stream().map(p -> p.name()).collect(Collectors.toList()))));
    }

    public List<PropertyModelBuilder> propertyModels() {
        return this.propertyModels;
    }

    @Nullable
    public String versionPropertyName() {
        return this.versionPropertyName;
    }

    public EntityModelBuilder versionPropertyName(String name) {
        this.versionPropertyName = name;
        return this;
    }

    public List<EntityModel> interfaces() {
        return this.interfaceModels;
    }

    public boolean isDiscriminatorEnabled() {
        return this.discriminatorEnabled;
    }

    private Map<String, Type> mapArguments(@Nullable Class<?> type2, Type typeSignature) {
        TypeVariable<Class<?>>[] typeParameters;
        HashMap<String, Type> map = new HashMap<String, Type>();
        if (type2 != null && typeSignature instanceof ParameterizedType && (typeParameters = type2.getTypeParameters()).length != 0) {
            Type[] arguments = ((ParameterizedType)typeSignature).getActualTypeArguments();
            for (int i2 = 0; i2 < typeParameters.length; ++i2) {
                TypeVariable<Class<?>> typeParameter = typeParameters[i2];
                map.put(typeParameter.getName(), arguments[i2]);
            }
        }
        return map;
    }

    protected Map<Class<? extends Annotation>, Annotation> annotationsMap() {
        return this.annotationsMap;
    }

    protected String getCollectionName() {
        Entity entityAn = this.getAnnotation(Entity.class);
        return entityAn != null && !entityAn.value().equals(".") ? entityAn.value() : this.datastore.getMapper().getOptions().getCollectionNaming().apply(this.type.getSimpleName());
    }

    protected Datastore getDatastore() {
        return this.datastore;
    }

    private void buildHierarchy(Class<?> type2) {
        this.annotations.addAll(Set.of(type2.getAnnotations()));
        this.interfaces.addAll(this.findInterfaces(type2));
        this.classes.addAll(this.findParentClasses(type2.getSuperclass()));
        this.classes.forEach(c -> this.interfaces.addAll(this.findInterfaces((Class<?>)c)));
    }

    private List<? extends Class<?>> findInterfaces(Class<?> type2) {
        ArrayList list = new ArrayList();
        List<Class<?>> interfaces = Arrays.asList(type2.getInterfaces());
        this.annotations.addAll(Set.of(type2.getAnnotations()));
        list.addAll(interfaces);
        list.addAll(interfaces.stream().flatMap(i2 -> this.findInterfaces((Class<?>)i2).stream()).collect(Collectors.toList()));
        return list;
    }

    private void propagateTypes() {
        ArrayList<Map<String, Type>> parameters = new ArrayList<Map<String, Type>>(this.parameterization.values());
        for (int index = 0; index < parameters.size(); ++index) {
            Map current = (Map)parameters.get(index);
            if (index + 1 >= parameters.size()) continue;
            for (Map.Entry entry : current.entrySet()) {
                int peek = index + 1;
                while (entry.getValue() instanceof TypeVariable) {
                    TypeVariable typeVariable = (TypeVariable)entry.getValue();
                    Map next2 = (Map)parameters.get(peek++);
                    entry.setValue((Type)next2.get(typeVariable.getName()));
                }
            }
        }
    }

    public TypeData<?> getTypeData(Class<?> type2, TypeData<?> suggested, Type genericType) {
        Type mapped;
        Map<String, Type> map;
        if (genericType instanceof TypeVariable && (map = this.parameterization.get(type2.getName())) != null && (mapped = map.get(((TypeVariable)genericType).getName())) instanceof Class) {
            suggested = TypeData.newInstance(genericType, (Class)mapped);
        }
        return suggested;
    }
}

