/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.pojo;

import com.mongodb.lang.Nullable;
import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.MorphiaCodec;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import java.util.Collection;
import java.util.Map;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.IdGenerator;
import org.bson.codecs.ObjectIdGenerator;
import org.bson.types.ObjectId;

class EntityEncoder
implements Encoder<Object> {
    public static final ObjectIdGenerator OBJECT_ID_GENERATOR = new ObjectIdGenerator();
    private final MorphiaCodec morphiaCodec;
    private IdGenerator idGenerator;

    protected EntityEncoder(MorphiaCodec morphiaCodec) {
        this.morphiaCodec = morphiaCodec;
    }

    @Override
    public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
        EntityModel model = this.morphiaCodec.getEntityModel();
        if (this.areEquivalentTypes(value.getClass(), model.getType())) {
            ExpressionHelper.document(writer, () -> {
                PropertyModel idModel = model.getIdProperty();
                this.encodeIdProperty(writer, value, encoderContext, idModel);
                if (model.useDiscriminator()) {
                    this.encodeDiscriminator(writer, model);
                }
                for (PropertyModel propertyModel : model.getProperties()) {
                    if (propertyModel.equals(idModel)) continue;
                    this.encodeValue(writer, encoderContext, propertyModel, propertyModel.getAccessor().get(value));
                }
            });
        } else {
            this.morphiaCodec.getRegistry().get(value.getClass()).encode(writer, value, encoderContext);
        }
    }

    @Override
    public Class<Object> getEncoderClass() {
        return this.morphiaCodec.getEncoderClass();
    }

    protected void encodeDiscriminator(BsonWriter writer, EntityModel model) {
        writer.writeString(model.getDiscriminatorKey(), model.getDiscriminator());
    }

    protected MorphiaCodec getMorphiaCodec() {
        return this.morphiaCodec;
    }

    private <S, V> boolean areEquivalentTypes(Class<S> t1, Class<V> t2) {
        return t1.equals(t2) || Collection.class.isAssignableFrom(t1) && Collection.class.isAssignableFrom(t2) || Map.class.isAssignableFrom(t1) && Map.class.isAssignableFrom(t2);
    }

    protected void encodeIdProperty(BsonWriter writer, Object instance, EncoderContext encoderContext, @Nullable PropertyModel idModel) {
        if (idModel != null) {
            IdGenerator generator = this.getIdGenerator();
            if (generator == null) {
                this.encodeValue(writer, encoderContext, idModel, idModel.getAccessor().get(instance));
            } else {
                Object id = idModel.getAccessor().get(instance);
                if (id == null && encoderContext.isEncodingCollectibleDocument()) {
                    id = generator.generate();
                    idModel.getAccessor().set(instance, id);
                }
                this.encodeValue(writer, encoderContext, idModel, id);
            }
        }
    }

    protected void encodeValue(BsonWriter writer, EncoderContext encoderContext, PropertyModel model, @Nullable Object value) {
        if (model.shouldSerialize(value)) {
            this.writeValue(writer, encoderContext, model, value);
        }
    }

    protected void writeValue(BsonWriter writer, EncoderContext encoderContext, PropertyModel model, @Nullable Object value) {
        writer.writeName(model.getMappedName());
        if (value == null) {
            writer.writeNull();
        } else {
            Codec<? super Object> cachedCodec = model.getCachedCodec();
            encoderContext.encodeWithChildContext(cachedCodec, writer, value);
        }
    }

    @Nullable
    private IdGenerator getIdGenerator() {
        PropertyModel idModel;
        if (this.idGenerator == null && (idModel = this.morphiaCodec.getEntityModel().getIdProperty()) != null && idModel.getNormalizedType().isAssignableFrom(ObjectId.class)) {
            this.idGenerator = OBJECT_ID_GENERATOR;
        }
        return this.idGenerator;
    }
}

