/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import dev.morphia.mapping.Mapper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

class TypedArrayCodec
implements Codec {
    private final Class type;
    private Codec codec;
    private final Mapper mapper;

    TypedArrayCodec(Class type2, Mapper mapper) {
        this.type = type2;
        this.mapper = mapper;
    }

    @Override
    public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
        writer.writeStartArray();
        int length = Array.getLength(value);
        for (int i2 = 0; i2 < length; ++i2) {
            Object element = Array.get(value, i2);
            if (element == null) {
                writer.writeNull();
                continue;
            }
            this.getCodec().encode(writer, element, encoderContext);
        }
        writer.writeEndArray();
    }

    @Override
    public Class getEncoderClass() {
        return Array.newInstance(this.type, 0).getClass();
    }

    private Codec getCodec() {
        if (this.codec == null) {
            this.codec = this.mapper.getCodecRegistry().get(this.type);
        }
        return this.codec;
    }

    @Override
    public Object decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartArray();
        ArrayList list = new ArrayList();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            list.add(this.getCodec().decode(reader, decoderContext));
        }
        reader.readEndArray();
        Object array = Array.newInstance(this.type, list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Array.set(array, i2, list.get(i2));
        }
        return array;
    }

    public String toString() {
        return String.format("%s<%s>", this.getClass().getName(), this.type.getSimpleName());
    }
}

