/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import com.mongodb.lang.Nullable;
import dev.morphia.annotations.LoadOnly;
import dev.morphia.annotations.NotSaved;
import dev.morphia.mapping.MapperOptions;
import dev.morphia.mapping.codec.pojo.PropertyModelBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bson.codecs.pojo.PropertySerialization;

public class MorphiaPropertySerialization
implements PropertySerialization {
    private final List<Annotation> annotations;
    private final MapperOptions options;
    private final int modifiers;

    public MorphiaPropertySerialization(MapperOptions options, PropertyModelBuilder property) {
        this.options = options;
        this.annotations = property.annotations();
        this.modifiers = property.modifiers();
    }

    public boolean shouldSerialize(@Nullable Object value) {
        if (!this.options.isStoreNulls() && value == null) {
            return false;
        }
        if (this.options.isIgnoreFinals() && Modifier.isFinal(this.modifiers)) {
            return false;
        }
        if (!this.options.isStoreEmpties() && (value instanceof Map && ((Map)value).isEmpty() || value instanceof Collection && ((Collection)value).isEmpty())) {
            return false;
        }
        return !this.hasAnnotation(LoadOnly.class) && !this.hasAnnotation(NotSaved.class);
    }

    private boolean hasAnnotation(Class<? extends Annotation> annotationClass) {
        return this.annotations.stream().anyMatch(a -> a.annotationType().equals(annotationClass));
    }
}

