/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import com.mongodb.lang.Nullable;
import dev.morphia.mapping.codec.MorphiaCollectionCodec;
import dev.morphia.mapping.codec.MorphiaPropertyCodecProvider;
import dev.morphia.mapping.codec.pojo.TypeData;
import java.util.Collection;
import java.util.List;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.PropertyCodecRegistry;
import org.bson.codecs.pojo.TypeWithTypeParameters;

public class MorphiaCollectionPropertyCodecProvider
extends MorphiaPropertyCodecProvider {
    @Override
    @Nullable
    public <T> Codec<T> get(TypeWithTypeParameters<T> type2, PropertyCodecRegistry registry) {
        if (Collection.class.isAssignableFrom(type2.getType())) {
            List<TypeWithTypeParameters<?>> typeParameters = type2.getTypeParameters();
            TypeWithTypeParameters<?> valueType = this.getType(typeParameters, 0);
            try {
                return new MorphiaCollectionCodec(registry.get(valueType), type2.getType());
            }
            catch (CodecConfigurationException e) {
                if (valueType.getType().equals(Object.class)) {
                    try {
                        return registry.get(TypeData.builder(Collection.class).build());
                    }
                    catch (CodecConfigurationException codecConfigurationException) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
        return null;
    }
}

