/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public abstract class NamingStrategy {
    public static NamingStrategy identity() {
        return new NamingStrategy(){

            @Override
            public String apply(String value) {
                return value;
            }
        };
    }

    public static NamingStrategy lowerCase() {
        return new NamingStrategy(){

            @Override
            public String apply(String value) {
                return value.toLowerCase();
            }
        };
    }

    public static NamingStrategy snakeCase() {
        return new NamingStrategy(){

            @Override
            public String apply(String value) {
                List<String> groups2 = NamingStrategy.groupByCapitals(value);
                StringJoiner joiner = new StringJoiner("_");
                for (String group : groups2) {
                    joiner.add(group.toLowerCase());
                }
                return joiner.toString();
            }
        };
    }

    public static NamingStrategy camelCase() {
        return new NamingStrategy(){

            @Override
            public String apply(String value) {
                List<String> groups2 = NamingStrategy.groupByCapitals(value);
                StringJoiner joiner = new StringJoiner("");
                joiner.add(groups2.get(0).toLowerCase());
                for (int i2 = 1; i2 < groups2.size(); ++i2) {
                    joiner.add(groups2.get(i2));
                }
                return joiner.toString();
            }
        };
    }

    public static NamingStrategy kebabCase() {
        return new NamingStrategy(){

            @Override
            public String apply(String value) {
                List<String> groups2 = NamingStrategy.groupByCapitals(value);
                StringJoiner joiner = new StringJoiner("-");
                joiner.add(groups2.get(0).toLowerCase());
                for (int i2 = 1; i2 < groups2.size(); ++i2) {
                    joiner.add(groups2.get(i2).toLowerCase());
                }
                return joiner.toString();
            }
        };
    }

    public abstract String apply(String var1);

    private static List<String> groupByCapitals(String value) {
        ArrayList<String> groups2 = new ArrayList<String>();
        StringBuilder builder = null;
        int length = value.length();
        for (int index = 0; index < length; ++index) {
            char current = value.charAt(index);
            if (index == 0 || Character.isUpperCase(current)) {
                if (builder != null) {
                    groups2.add(builder.toString());
                }
                builder = new StringBuilder();
            }
            builder.append(current);
        }
        groups2.add(builder.toString());
        return groups2;
    }
}

