/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping;

import com.mongodb.lang.Nullable;
import dev.morphia.mapping.codec.pojo.EntityModel;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.bson.codecs.configuration.CodecConfigurationException;

public final class DiscriminatorLookup {
    private final Map<String, Class<?>> discriminatorClassMap = new ConcurrentHashMap();
    private final Set<String> packages = new ConcurrentSkipListSet<String>();
    private final ClassLoader classLoader;

    public DiscriminatorLookup(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void addModel(EntityModel entityModel) {
        this.discriminatorClassMap.put(entityModel.getDiscriminator(), entityModel.getType());
    }

    public Class<?> lookup(String discriminator) {
        if (this.discriminatorClassMap.containsKey(discriminator)) {
            return this.discriminatorClassMap.get(discriminator);
        }
        Class<?> clazz = this.getClassForName(discriminator);
        if (clazz == null) {
            clazz = this.searchPackages(discriminator);
        }
        if (clazz == null) {
            throw new CodecConfigurationException(String.format("A class could not be found for the discriminator: '%s'.", discriminator));
        }
        this.discriminatorClassMap.put(discriminator, clazz);
        return clazz;
    }

    @Nullable
    private Class<?> getClassForName(String discriminator) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(discriminator, true, this.classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    @Nullable
    private Class<?> searchPackages(String discriminator) {
        Class<?> clazz = null;
        for (String packageName : this.packages) {
            clazz = this.getClassForName(packageName + "." + discriminator);
            if (clazz == null) continue;
            return clazz;
        }
        return clazz;
    }
}

