/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.internal;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.client.MongoCollection;
import com.mongodb.lang.Nullable;

public interface ReadConfigurable<T> {
    @Nullable
    public ReadConcern getReadConcern();

    @Nullable
    public ReadPreference getReadPreference();

    default public <C> MongoCollection<C> prepare(MongoCollection<C> collection) {
        ReadPreference readPreference;
        MongoCollection<C> updated = collection;
        ReadConcern readConcern = this.getReadConcern();
        if (readConcern != null) {
            updated = updated.withReadConcern(readConcern);
        }
        if ((readPreference = this.getReadPreference()) != null) {
            updated = updated.withReadPreference(readPreference);
        }
        return updated;
    }

    public T readConcern(ReadConcern var1);

    public T readPreference(ReadPreference var1);
}

