/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental.expressions.impls;

import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.aggregation.experimental.expressions.impls.Expression;
import dev.morphia.mapping.Mapper;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class SliceExpression
extends Expression {
    private final Expression array;
    private final int size;
    private Integer position;

    public SliceExpression(Expression array, int size) {
        super("$slice");
        this.array = array;
        this.size = size;
    }

    @Override
    public void encode(Mapper mapper, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> ExpressionHelper.array(writer, this.getOperation(), () -> {
            ExpressionHelper.expression(mapper, writer, this.array, encoderContext);
            if (this.position != null) {
                writer.writeInt32(this.position);
            }
            writer.writeInt32(this.size);
        }));
    }

    public SliceExpression position(Integer position) {
        this.position = position;
        return this;
    }
}

