/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental.expressions.impls;

import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.aggregation.experimental.expressions.impls.Expression;
import dev.morphia.mapping.Mapper;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class RangeExpression
extends Expression {
    private final int start;
    private final int end;
    private Integer step;

    public RangeExpression(int start2, int end) {
        super("$range");
        this.start = start2;
        this.end = end;
    }

    @Override
    public void encode(Mapper mapper, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> ExpressionHelper.array(writer, this.getOperation(), () -> {
            writer.writeInt32(this.start);
            writer.writeInt32(this.end);
            if (this.step != null) {
                writer.writeInt32(this.step);
            }
        }));
    }

    public RangeExpression step(Integer step) {
        this.step = step;
        return this;
    }
}

