/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental.expressions.impls;

import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.aggregation.experimental.expressions.impls.Expression;
import dev.morphia.mapping.Mapper;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class AccumulatorExpression
extends Expression {
    private final String initFunction;
    private final String accumulateFunction;
    private final List<Expression> accumulateArgs;
    private final String mergeFunction;
    private final String lang = "js";
    private List<Expression> initArgs;
    private String finalizeFunction;

    public AccumulatorExpression(String initFunction, String accumulateFunction, List<Expression> accumulateArgs, String mergeFunction) {
        super("$accumulator");
        this.initFunction = initFunction;
        this.accumulateFunction = accumulateFunction;
        this.accumulateArgs = accumulateArgs;
        this.mergeFunction = mergeFunction;
    }

    @Override
    public void encode(Mapper mapper, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> ExpressionHelper.document(writer, this.getOperation(), () -> {
            ExpressionHelper.value(mapper, writer, "init", this.initFunction, encoderContext);
            ExpressionHelper.value(mapper, writer, "initArgs", this.initArgs, encoderContext);
            ExpressionHelper.value(mapper, writer, "accumulate", this.accumulateFunction, encoderContext);
            ExpressionHelper.value(mapper, writer, "accumulateArgs", this.accumulateArgs, encoderContext);
            ExpressionHelper.value(mapper, writer, "merge", this.mergeFunction, encoderContext);
            ExpressionHelper.value(mapper, writer, "finalize", this.finalizeFunction, encoderContext);
            ExpressionHelper.value(mapper, writer, "lang", "js", encoderContext);
        }));
    }

    public AccumulatorExpression finalizeFunction(String finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    public AccumulatorExpression initArgs(List<Expression> initArgs) {
        this.initArgs = initArgs;
        return this;
    }
}

