/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental.codecs.stages;

import com.mongodb.client.MongoCollection;
import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.aggregation.experimental.codecs.stages.StageCodec;
import dev.morphia.aggregation.experimental.stages.Lookup;
import dev.morphia.mapping.Mapper;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class LookupCodec
extends StageCodec<Lookup> {
    public LookupCodec(Mapper mapper) {
        super(mapper);
    }

    @Override
    public Class<Lookup> getEncoderClass() {
        return Lookup.class;
    }

    @Override
    protected void encodeStage(BsonWriter writer, Lookup value, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            if (value.getFrom() != null) {
                ExpressionHelper.value(this.getMapper(), writer, "from", value.getFrom(), encoderContext);
            } else {
                MongoCollection<?> collection = this.getMapper().getCollection(value.getFromType());
                writer.writeString("from", collection.getNamespace().getCollectionName());
            }
            if (value.getPipeline() == null) {
                writer.writeString("localField", value.getLocalField());
                writer.writeString("foreignField", value.getForeignField());
            } else {
                ExpressionHelper.value(this.getMapper(), writer, "let", value.getVariables(), encoderContext);
                ExpressionHelper.value(this.getMapper(), writer, "pipeline", value.getPipeline(), encoderContext);
            }
            writer.writeString("as", value.getAs());
        });
    }
}

