/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental.codecs.stages;

import com.mongodb.client.MongoCollection;
import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.aggregation.experimental.codecs.stages.StageCodec;
import dev.morphia.aggregation.experimental.stages.GraphLookup;
import dev.morphia.mapping.Mapper;
import dev.morphia.query.experimental.filters.Filter;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class GraphLookupCodec
extends StageCodec<GraphLookup> {
    public GraphLookupCodec(Mapper mapper) {
        super(mapper);
    }

    @Override
    public Class<GraphLookup> getEncoderClass() {
        return GraphLookup.class;
    }

    @Override
    protected void encodeStage(BsonWriter writer, GraphLookup value, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            if (value.getFrom() != null) {
                ExpressionHelper.value(this.getMapper(), writer, "from", value.getFrom(), encoderContext);
            } else {
                MongoCollection collection = this.getMapper().getCollection(value.getFromType());
                writer.writeString("from", collection.getNamespace().getCollectionName());
            }
            ExpressionHelper.expression(this.getMapper(), writer, "startWith", value.getStartWith(), encoderContext);
            ExpressionHelper.value(this.getMapper(), writer, "connectFromField", value.getConnectFromField(), encoderContext);
            ExpressionHelper.value(this.getMapper(), writer, "connectToField", value.getConnectToField(), encoderContext);
            ExpressionHelper.value(this.getMapper(), writer, "as", value.getAs(), encoderContext);
            ExpressionHelper.value(this.getMapper(), writer, "maxDepth", value.getMaxDepth(), encoderContext);
            ExpressionHelper.value(this.getMapper(), writer, "depthField", value.getDepthField(), encoderContext);
            Filter[] restriction = value.getRestriction();
            if (restriction != null) {
                ExpressionHelper.document(writer, "restrictSearchWithMatch", () -> {
                    for (Filter filter : restriction) {
                        filter.encode(this.getMapper(), writer, encoderContext);
                    }
                });
            }
        });
    }
}

