/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia;

import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.model.Collation;
import com.mongodb.lang.Nullable;
import dev.morphia.internal.SessionConfigurable;
import dev.morphia.internal.WriteConfigurable;
import dev.morphia.query.experimental.filters.Filter;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public class UpdateOptions
extends com.mongodb.client.model.UpdateOptions
implements SessionConfigurable<UpdateOptions>,
WriteConfigurable<UpdateOptions> {
    private WriteConcern writeConcern;
    private boolean multi;
    private ClientSession clientSession;

    public UpdateOptions arrayFilter(Filter filter) {
        ArrayList<? extends Bson> arrayFilters = new ArrayList<Bson>();
        if (this.getArrayFilters() != null) {
            arrayFilters.addAll(this.getArrayFilters());
        }
        Document filterDoc = new Document(filter.getName(), filter.getValue());
        if (filter.isNot()) {
            filterDoc = new Document("$not", filterDoc);
        }
        arrayFilters.add(new Document(filter.getField(), filterDoc));
        this.arrayFilters(arrayFilters);
        return this;
    }

    @Override
    public UpdateOptions clientSession(@Nullable ClientSession clientSession) {
        this.clientSession = clientSession;
        return this;
    }

    @Override
    @Nullable
    public ClientSession clientSession() {
        return this.clientSession;
    }

    public UpdateOptions hint(Document hint) {
        super.hint(hint);
        return this;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public UpdateOptions multi(boolean multi) {
        this.multi = multi;
        return this;
    }

    @Override
    public UpdateOptions upsert(boolean upsert) {
        super.upsert(upsert);
        return this;
    }

    @Override
    public UpdateOptions bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        super.bypassDocumentValidation(bypassDocumentValidation);
        return this;
    }

    @Override
    public UpdateOptions collation(@Nullable Collation collation) {
        super.collation(collation);
        return this;
    }

    @Override
    public UpdateOptions arrayFilters(@Nullable List<? extends Bson> arrayFilters) {
        super.arrayFilters(arrayFilters);
        return this;
    }

    @Override
    public UpdateOptions hint(@Nullable Bson hint) {
        super.hint(hint);
        return this;
    }

    @Override
    public UpdateOptions hintString(@Nullable String hint) {
        super.hintString(hint);
        return this;
    }

    @Override
    public UpdateOptions writeConcern(@Nullable WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
        return this;
    }

    @Override
    public WriteConcern writeConcern() {
        return this.writeConcern;
    }
}

