/*
 * Decompiled with CFR 0.152.
 */
package org.reflections8.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.reflections8.util.SetMultimap;

public class HashSetMultimap<T, V>
extends HashMap<T, Set<V>>
implements SetMultimap<T, V> {
    private static final long serialVersionUID = 140511307437539771L;
    private final transient Supplier<Set<V>> setSupplier;

    public HashSetMultimap() {
        this.setSupplier = () -> new HashSet();
    }

    public HashSetMultimap(Supplier<Set<V>> setSupplier) {
        this.setSupplier = setSupplier;
    }

    @Override
    public boolean putSingle(T key, V value) {
        Set vs = (Set)super.get(key);
        if (vs != null) {
            return vs.add(value);
        }
        Set<V> setValue = this.setSupplier.get();
        setValue.add(value);
        super.put(key, setValue);
        return true;
    }

    @Override
    public void putAllSingles(SetMultimap<T, V> m3) {
        for (Object key : m3.keySet()) {
            Set val = (Set)m3.get(key);
            Set vs = (Set)super.get(key);
            if (vs != null) {
                if (val == null) continue;
                vs.addAll(val);
                continue;
            }
            if (val == null) {
                super.put(key, null);
                continue;
            }
            Set<V> setValue = this.setSupplier.get();
            if (val != null) {
                setValue.addAll((Collection)m3.get(key));
            }
            super.put(key, setValue);
        }
    }

    @Override
    public boolean removeSingle(Object key, V value) {
        Set vs = (Set)super.get(key);
        if (vs == null) {
            return false;
        }
        boolean res = vs.remove(value);
        if (vs.isEmpty()) {
            super.remove(key);
        }
        return res;
    }

    @Override
    public Collection<V> flatValues() {
        ArrayList res = new ArrayList();
        for (Set s2 : this.values()) {
            res.addAll(s2);
        }
        return res;
    }

    @Override
    public Set<V> flatValuesAsSet() {
        HashSet res = new HashSet();
        for (Set s2 : this.values()) {
            res.addAll(s2);
        }
        return res;
    }

    @Override
    public Map<T, Set<V>> asMap() {
        HashMap result = new HashMap();
        for (Map.Entry e : this.entrySet()) {
            if (e.getValue() == null || ((Set)e.getValue()).isEmpty()) continue;
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }
}

