/*
 * Decompiled with CFR 0.152.
 */
package org.reflections8.scanners;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import org.reflections8.adapters.MetadataAdapter;
import org.reflections8.scanners.AbstractScanner;
import org.reflections8.util.Joiner;

public class MethodParameterNamesScanner
extends AbstractScanner {
    @Override
    public void scan(Object cls) {
        MetadataAdapter md = this.getMetadataAdapter();
        for (Object method : md.getMethods(cls)) {
            String key = md.getMethodFullKey(cls, method);
            if (!this.acceptResult(key)) continue;
            LocalVariableAttribute table = (LocalVariableAttribute)((MethodInfo)method).getCodeAttribute().getAttribute("LocalVariableTable");
            int length = table.tableLength();
            int i2 = Modifier.isStatic(((MethodInfo)method).getAccessFlags()) ? 0 : 1;
            if (i2 >= length) continue;
            ArrayList<String> names = new ArrayList<String>(length - i2);
            while (i2 < length) {
                names.add(((MethodInfo)method).getConstPool().getUtf8Info(table.nameIndex(i2++)));
            }
            this.getStore().putSingle(key, Joiner.on(", ").join(names));
        }
    }
}

