/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.quartz.impl.jdbcjobstore.TriggerPersistenceDelegate;
import org.quartz.spi.OperableTrigger;

public class PointbaseDelegate
extends StdJDBCDelegate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
        int len2 = baos.toByteArray().length;
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PreparedStatement ps = null;
        int insertResult = 0;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}JOB_DETAILS (SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_NONCONCURRENT, IS_UPDATE_DATA, REQUESTS_RECOVERY, JOB_DATA)  VALUES({1}, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
            ps.setString(1, job.getKey().getName());
            ps.setString(2, job.getKey().getGroup());
            ps.setString(3, job.getDescription());
            ps.setString(4, job.getJobClass().getName());
            this.setBoolean(ps, 5, job.isDurable());
            this.setBoolean(ps, 6, job.isConcurrentExectionDisallowed());
            this.setBoolean(ps, 7, job.isPersistJobDataAfterExecution());
            this.setBoolean(ps, 8, job.requestsRecovery());
            ps.setBinaryStream(9, (InputStream)bais, len2);
            insertResult = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            PointbaseDelegate.closeStatement(ps);
            throw throwable;
        }
        PointbaseDelegate.closeStatement(ps);
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
        int len2 = baos.toByteArray().length;
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PreparedStatement ps = null;
        int insertResult = 0;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET DESCRIPTION = ?, JOB_CLASS_NAME = ?, IS_DURABLE = ?, IS_NONCONCURRENT = ?, IS_UPDATE_DATA = ?, REQUESTS_RECOVERY = ?, JOB_DATA = ?  WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, job.getDescription());
            ps.setString(2, job.getJobClass().getName());
            this.setBoolean(ps, 3, job.isDurable());
            this.setBoolean(ps, 4, job.isConcurrentExectionDisallowed());
            this.setBoolean(ps, 5, job.isPersistJobDataAfterExecution());
            this.setBoolean(ps, 6, job.requestsRecovery());
            ps.setBinaryStream(7, (InputStream)bais, len2);
            ps.setString(8, job.getKey().getName());
            ps.setString(9, job.getKey().getGroup());
            insertResult = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            PointbaseDelegate.closeStatement(ps);
            throw throwable;
        }
        PointbaseDelegate.closeStatement(ps);
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertTrigger(Connection conn, OperableTrigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        int insertResult;
        PreparedStatement ps;
        block6: {
            ByteArrayOutputStream baos = this.serializeJobData(trigger.getJobDataMap());
            int len2 = baos.toByteArray().length;
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ps = null;
            insertResult = 0;
            try {
                ps = conn.prepareStatement(this.rtp("INSERT INTO {0}TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA, PRIORITY)  VALUES({1}, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
                ps.setString(1, trigger.getKey().getName());
                ps.setString(2, trigger.getKey().getGroup());
                ps.setString(3, trigger.getJobKey().getName());
                ps.setString(4, trigger.getJobKey().getGroup());
                ps.setString(5, trigger.getDescription());
                ps.setBigDecimal(6, new BigDecimal(String.valueOf(trigger.getNextFireTime().getTime())));
                long prevFireTime = -1L;
                if (trigger.getPreviousFireTime() != null) {
                    prevFireTime = trigger.getPreviousFireTime().getTime();
                }
                ps.setBigDecimal(7, new BigDecimal(String.valueOf(prevFireTime)));
                ps.setString(8, state);
                TriggerPersistenceDelegate tDel = this.findTriggerPersistenceDelegate(trigger);
                String type2 = "BLOB";
                if (tDel != null) {
                    type2 = tDel.getHandledTriggerTypeDiscriminator();
                }
                ps.setString(9, type2);
                ps.setBigDecimal(10, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
                long endTime = 0L;
                if (trigger.getEndTime() != null) {
                    endTime = trigger.getEndTime().getTime();
                }
                ps.setBigDecimal(11, new BigDecimal(String.valueOf(endTime)));
                ps.setString(12, trigger.getCalendarName());
                ps.setInt(13, trigger.getMisfireInstruction());
                ps.setBinaryStream(14, (InputStream)bais, len2);
                ps.setInt(15, trigger.getPriority());
                insertResult = ps.executeUpdate();
                if (tDel == null) {
                    this.insertBlobTrigger(conn, trigger);
                    break block6;
                }
                tDel.insertExtendedTriggerProperties(conn, trigger, state, jobDetail);
            }
            catch (Throwable throwable) {
                PointbaseDelegate.closeStatement(ps);
                throw throwable;
            }
        }
        PointbaseDelegate.closeStatement(ps);
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateTrigger(Connection conn, OperableTrigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        int insertResult;
        PreparedStatement ps;
        block7: {
            ByteArrayOutputStream baos = this.serializeJobData(trigger.getJobDataMap());
            int len2 = baos.toByteArray().length;
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ps = null;
            insertResult = 0;
            try {
                ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, PRIORITY = ?, JOB_DATA = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                ps.setString(1, trigger.getJobKey().getName());
                ps.setString(2, trigger.getJobKey().getGroup());
                ps.setString(3, trigger.getDescription());
                long nextFireTime = -1L;
                if (trigger.getNextFireTime() != null) {
                    nextFireTime = trigger.getNextFireTime().getTime();
                }
                ps.setBigDecimal(4, new BigDecimal(String.valueOf(nextFireTime)));
                long prevFireTime = -1L;
                if (trigger.getPreviousFireTime() != null) {
                    prevFireTime = trigger.getPreviousFireTime().getTime();
                }
                ps.setBigDecimal(5, new BigDecimal(String.valueOf(prevFireTime)));
                ps.setString(6, state);
                TriggerPersistenceDelegate tDel = this.findTriggerPersistenceDelegate(trigger);
                String type2 = "BLOB";
                if (tDel != null) {
                    type2 = tDel.getHandledTriggerTypeDiscriminator();
                }
                ps.setString(7, type2);
                ps.setBigDecimal(8, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
                long endTime = 0L;
                if (trigger.getEndTime() != null) {
                    endTime = trigger.getEndTime().getTime();
                }
                ps.setBigDecimal(9, new BigDecimal(String.valueOf(endTime)));
                ps.setString(10, trigger.getCalendarName());
                ps.setInt(11, trigger.getMisfireInstruction());
                ps.setInt(12, trigger.getPriority());
                ps.setBinaryStream(13, (InputStream)bais, len2);
                ps.setString(14, trigger.getKey().getName());
                ps.setString(15, trigger.getKey().getGroup());
                insertResult = ps.executeUpdate();
                if (tDel == null) {
                    this.updateBlobTrigger(conn, trigger);
                    break block7;
                }
                tDel.updateExtendedTriggerProperties(conn, trigger, state, jobDetail);
            }
            catch (Throwable throwable) {
                PointbaseDelegate.closeStatement(ps);
                throw throwable;
            }
        }
        PointbaseDelegate.closeStatement(ps);
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateJobData(Connection conn, JobDetail job) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
        int len2 = baos.toByteArray().length;
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET JOB_DATA = ?  WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setBinaryStream(1, (InputStream)bais, len2);
            ps.setString(2, job.getKey().getName());
            ps.setString(3, job.getKey().getGroup());
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            PointbaseDelegate.closeStatement(ps);
            throw throwable;
        }
        PointbaseDelegate.closeStatement(ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream baos = this.serializeObject(calendar);
        byte[] buf = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}CALENDARS (SCHED_NAME, CALENDAR_NAME, CALENDAR)  VALUES({1}, ?, ?)"));
            ps.setString(1, calendarName);
            ps.setBinaryStream(2, (InputStream)bais, buf.length);
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            PointbaseDelegate.closeStatement(ps);
            throw throwable;
        }
        PointbaseDelegate.closeStatement(ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream baos = this.serializeObject(calendar);
        byte[] buf = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE SCHED_NAME = {1} AND CALENDAR_NAME = ?"));
            ps.setBinaryStream(1, (InputStream)bais, buf.length);
            ps.setString(2, calendarName);
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            PointbaseDelegate.closeStatement(ps);
            throw throwable;
        }
        PointbaseDelegate.closeStatement(ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object getObjectFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        Object obj = null;
        byte[] binaryData = rs.getBytes(colName);
        ByteArrayInputStream binaryInput = new ByteArrayInputStream(binaryData);
        if (null != binaryInput && ((InputStream)binaryInput).available() != 0) {
            try (ObjectInputStream in = new ObjectInputStream(binaryInput);){
                obj = in.readObject();
            }
        }
        return obj;
    }

    @Override
    protected Object getJobDataFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        if (this.canUseProperties()) {
            byte[] data = rs.getBytes(colName);
            if (data == null) {
                return null;
            }
            ByteArrayInputStream binaryInput = new ByteArrayInputStream(data);
            return binaryInput;
        }
        return this.getObjectFromBlob(rs, colName);
    }
}

