/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core.jmx;

import java.util.ArrayList;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.quartz.JobDetail;
import org.quartz.core.jmx.JobDataMapSupport;
import org.quartz.impl.JobDetailImpl;

public class JobDetailSupport {
    private static final String COMPOSITE_TYPE_NAME = "JobDetail";
    private static final String COMPOSITE_TYPE_DESCRIPTION = "Job Execution Details";
    private static final String[] ITEM_NAMES = new String[]{"name", "group", "description", "jobClass", "jobDataMap", "durability", "shouldRecover"};
    private static final String[] ITEM_DESCRIPTIONS = new String[]{"name", "group", "description", "jobClass", "jobDataMap", "durability", "shouldRecover"};
    private static final OpenType[] ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, JobDataMapSupport.TABULAR_TYPE, SimpleType.BOOLEAN, SimpleType.BOOLEAN};
    private static final CompositeType COMPOSITE_TYPE;
    private static final String TABULAR_TYPE_NAME = "JobDetail collection";
    private static final String TABULAR_TYPE_DESCRIPTION = "JobDetail collection";
    private static final String[] INDEX_NAMES;
    private static final TabularType TABULAR_TYPE;

    public static JobDetail newJobDetail(CompositeData cData) throws ClassNotFoundException {
        Class<?> jobClass;
        JobDetailImpl jobDetail = new JobDetailImpl();
        int i2 = 0;
        jobDetail.setName((String)cData.get(ITEM_NAMES[i2++]));
        jobDetail.setGroup((String)cData.get(ITEM_NAMES[i2++]));
        jobDetail.setDescription((String)cData.get(ITEM_NAMES[i2++]));
        Class<?> jobClassTyped = jobClass = Class.forName((String)cData.get(ITEM_NAMES[i2++]));
        jobDetail.setJobClass(jobClassTyped);
        jobDetail.setJobDataMap(JobDataMapSupport.newJobDataMap((TabularData)cData.get(ITEM_NAMES[i2++])));
        jobDetail.setDurability((Boolean)cData.get(ITEM_NAMES[i2++]));
        jobDetail.setRequestsRecovery((Boolean)cData.get(ITEM_NAMES[i2++]));
        return jobDetail;
    }

    public static JobDetail newJobDetail(Map<String, Object> attrMap) throws ClassNotFoundException {
        Class<?> jobClass;
        JobDetailImpl jobDetail = new JobDetailImpl();
        int i2 = 0;
        jobDetail.setName((String)attrMap.get(ITEM_NAMES[i2++]));
        jobDetail.setGroup((String)attrMap.get(ITEM_NAMES[i2++]));
        jobDetail.setDescription((String)attrMap.get(ITEM_NAMES[i2++]));
        Class<?> jobClassTyped = jobClass = Class.forName((String)attrMap.get(ITEM_NAMES[i2++]));
        jobDetail.setJobClass(jobClassTyped);
        if (attrMap.containsKey(ITEM_NAMES[i2])) {
            Map map = (Map)attrMap.get(ITEM_NAMES[i2]);
            jobDetail.setJobDataMap(JobDataMapSupport.newJobDataMap(map));
        }
        if (attrMap.containsKey(ITEM_NAMES[++i2])) {
            jobDetail.setDurability((Boolean)attrMap.get(ITEM_NAMES[i2]));
        }
        if (attrMap.containsKey(ITEM_NAMES[++i2])) {
            jobDetail.setRequestsRecovery((Boolean)attrMap.get(ITEM_NAMES[i2]));
        }
        ++i2;
        return jobDetail;
    }

    public static CompositeData toCompositeData(JobDetail jobDetail) {
        try {
            return new CompositeDataSupport(COMPOSITE_TYPE, ITEM_NAMES, new Object[]{jobDetail.getKey().getName(), jobDetail.getKey().getGroup(), jobDetail.getDescription(), jobDetail.getJobClass().getName(), JobDataMapSupport.toTabularData(jobDetail.getJobDataMap()), jobDetail.isDurable(), jobDetail.requestsRecovery()});
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public static TabularData toTabularData(JobDetail[] jobDetails) {
        TabularDataSupport tData = new TabularDataSupport(TABULAR_TYPE);
        if (jobDetails != null) {
            ArrayList<CompositeData> list = new ArrayList<CompositeData>();
            for (JobDetail jobDetail : jobDetails) {
                list.add(JobDetailSupport.toCompositeData(jobDetail));
            }
            tData.putAll(list.toArray(new CompositeData[list.size()]));
        }
        return tData;
    }

    static {
        INDEX_NAMES = new String[]{"name", "group"};
        try {
            COMPOSITE_TYPE = new CompositeType(COMPOSITE_TYPE_NAME, COMPOSITE_TYPE_DESCRIPTION, ITEM_NAMES, ITEM_DESCRIPTIONS, ITEM_TYPES);
            TABULAR_TYPE = new TabularType("JobDetail collection", "JobDetail collection", COMPOSITE_TYPE, INDEX_NAMES);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }
}

