/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.ast;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.luaj.vm2.ast.Variable;

public class NameScope {
    private static final Set LUA_KEYWORDS = new HashSet();
    public final Map namedVariables = new HashMap();
    public final NameScope outerScope;
    public int functionNestingCount;

    public NameScope() {
        this.outerScope = null;
        this.functionNestingCount = 0;
    }

    public NameScope(NameScope nameScope) {
        this.outerScope = nameScope;
        this.functionNestingCount = nameScope != null ? nameScope.functionNestingCount : 0;
    }

    public Variable find(String string) throws IllegalArgumentException {
        this.validateIsNotKeyword(string);
        Object object = this;
        while (object != null) {
            if (((NameScope)object).namedVariables.containsKey(string)) {
                return (Variable)((NameScope)object).namedVariables.get(string);
            }
            object = ((NameScope)object).outerScope;
        }
        object = new Variable(string);
        this.namedVariables.put(string, object);
        return object;
    }

    public Variable define(String string) throws IllegalStateException, IllegalArgumentException {
        this.validateIsNotKeyword(string);
        Variable variable = new Variable(string, this);
        this.namedVariables.put(string, variable);
        return variable;
    }

    private void validateIsNotKeyword(String string) {
        if (LUA_KEYWORDS.contains(string)) {
            throw new IllegalArgumentException("name is a keyword: '" + string + "'");
        }
    }

    static {
        String[] stringArray = new String[]{"and", "break", "do", "else", "elseif", "end", "false", "for", "function", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while"};
        for (int j = 0; j < stringArray.length; ++j) {
            LUA_KEYWORDS.add(stringArray[j]);
        }
    }
}

