/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractPosixTerminal;
import org.jline.terminal.impl.AbstractTerminal;
import org.jline.terminal.impl.DumbTerminal;
import org.jline.terminal.impl.ExecPty;
import org.jline.terminal.impl.ExternalTerminal;
import org.jline.terminal.impl.PosixPtyTerminal;
import org.jline.terminal.impl.PosixSysTerminal;
import org.jline.terminal.spi.JansiSupport;
import org.jline.terminal.spi.JnaSupport;
import org.jline.terminal.spi.Pty;
import org.jline.utils.Log;
import org.jline.utils.OSUtils;

public final class TerminalBuilder {
    public static final String PROP_ENCODING = "org.jline.terminal.encoding";
    public static final String PROP_CODEPAGE = "org.jline.terminal.codepage";
    public static final String PROP_TYPE = "org.jline.terminal.type";
    public static final String PROP_JNA = "org.jline.terminal.jna";
    public static final String PROP_JANSI = "org.jline.terminal.jansi";
    public static final String PROP_EXEC = "org.jline.terminal.exec";
    public static final String PROP_DUMB = "org.jline.terminal.dumb";
    public static final String PROP_DUMB_COLOR = "org.jline.terminal.dumb.color";
    public static final String PROP_NON_BLOCKING_READS = "org.jline.terminal.pty.nonBlockingReads";
    public static final String PROP_COLOR_DISTANCE = "org.jline.utils.colorDistance";
    public static final String PROP_DISABLE_ALTERNATE_CHARSET = "org.jline.utils.disableAlternateCharset";
    private static final AtomicReference<Terminal> SYSTEM_TERMINAL = new AtomicReference();
    private static final AtomicReference<Terminal> TERMINAL_OVERRIDE = new AtomicReference();
    private String name;
    private InputStream in;
    private OutputStream out;
    private String type;
    private Charset encoding;
    private int codepage;
    private Boolean system;
    private Boolean jna;
    private Boolean jansi;
    private Boolean exec;
    private Boolean dumb;
    private Boolean color;
    private Attributes attributes;
    private Size size;
    private boolean nativeSignals = false;
    private Terminal.SignalHandler signalHandler = Terminal.SignalHandler.SIG_DFL;
    private boolean paused = false;

    public static Terminal terminal() throws IOException {
        return TerminalBuilder.builder().build();
    }

    public static TerminalBuilder builder() {
        return new TerminalBuilder();
    }

    private TerminalBuilder() {
    }

    public TerminalBuilder name(String name) {
        this.name = name;
        return this;
    }

    public TerminalBuilder streams(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        return this;
    }

    public TerminalBuilder system(boolean system) {
        this.system = system;
        return this;
    }

    public TerminalBuilder jna(boolean jna) {
        this.jna = jna;
        return this;
    }

    public TerminalBuilder jansi(boolean jansi) {
        this.jansi = jansi;
        return this;
    }

    public TerminalBuilder exec(boolean exec) {
        this.exec = exec;
        return this;
    }

    public TerminalBuilder dumb(boolean dumb) {
        this.dumb = dumb;
        return this;
    }

    public TerminalBuilder type(String type2) {
        this.type = type2;
        return this;
    }

    public TerminalBuilder color(boolean color) {
        this.color = color;
        return this;
    }

    public TerminalBuilder encoding(String encoding) throws UnsupportedCharsetException {
        return this.encoding(encoding != null ? Charset.forName(encoding) : null);
    }

    public TerminalBuilder encoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    @Deprecated
    public TerminalBuilder codepage(int codepage) {
        this.codepage = codepage;
        return this;
    }

    public TerminalBuilder attributes(Attributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public TerminalBuilder size(Size size) {
        this.size = size;
        return this;
    }

    public TerminalBuilder nativeSignals(boolean nativeSignals) {
        this.nativeSignals = nativeSignals;
        return this;
    }

    public TerminalBuilder signalHandler(Terminal.SignalHandler signalHandler) {
        this.signalHandler = signalHandler;
        return this;
    }

    public TerminalBuilder paused(boolean paused) {
        this.paused = paused;
        return this;
    }

    public Terminal build() throws IOException {
        Terminal terminal;
        Terminal override = TERMINAL_OVERRIDE.get();
        Terminal terminal2 = terminal = override != null ? override : this.doBuild();
        if (override != null) {
            Log.debug(() -> "Overriding terminal with global value set by TerminalBuilder.setTerminalOverride");
        }
        Log.debug(() -> "Using terminal " + terminal.getClass().getSimpleName());
        if (terminal instanceof AbstractPosixTerminal) {
            Log.debug(() -> "Using pty " + ((AbstractPosixTerminal)terminal).getPty().getClass().getSimpleName());
        }
        return terminal;
    }

    private Terminal doBuild() throws IOException {
        Boolean dumb;
        Boolean exec;
        Boolean jansi;
        Boolean jna;
        String type2;
        String str;
        int codepage;
        String charsetName;
        Charset encoding;
        String name = this.name;
        if (name == null) {
            name = "JLine terminal";
        }
        if ((encoding = this.encoding) == null && (charsetName = System.getProperty(PROP_ENCODING)) != null && Charset.isSupported(charsetName)) {
            encoding = Charset.forName(charsetName);
        }
        if ((codepage = this.codepage) <= 0 && (str = System.getProperty(PROP_CODEPAGE)) != null) {
            codepage = Integer.parseInt(str);
        }
        if ((type2 = this.type) == null) {
            type2 = System.getProperty(PROP_TYPE);
        }
        if (type2 == null) {
            type2 = System.getenv("TERM");
        }
        if ((jna = this.jna) == null) {
            jna = TerminalBuilder.getBoolean(PROP_JNA, true);
        }
        if ((jansi = this.jansi) == null) {
            jansi = TerminalBuilder.getBoolean(PROP_JANSI, true);
        }
        if ((exec = this.exec) == null) {
            exec = TerminalBuilder.getBoolean(PROP_EXEC, true);
        }
        if ((dumb = this.dumb) == null) {
            dumb = TerminalBuilder.getBoolean(PROP_DUMB, null);
        }
        if (this.system != null && this.system.booleanValue() || this.system == null && this.in == null && this.out == null) {
            if (this.system != null && (this.in != null && !this.in.equals(System.in) || this.out != null && !this.out.equals(System.out))) {
                throw new IllegalArgumentException("Cannot create a system terminal using non System streams");
            }
            Terminal terminal = null;
            IllegalStateException exception = new IllegalStateException("Unable to create a system terminal");
            TerminalBuilderSupport tbs = new TerminalBuilderSupport(jna, jansi);
            if (tbs.isConsoleInput() && tbs.isConsoleOutput()) {
                if (this.attributes != null || this.size != null) {
                    Log.warn("Attributes and size fields are ignored when creating a system terminal");
                }
                if (OSUtils.IS_WINDOWS) {
                    boolean ansiPassThrough = OSUtils.IS_CONEMU;
                    if (tbs.hasJnaSupport()) {
                        try {
                            terminal = tbs.getJnaSupport().winSysTerminal(name, type2, ansiPassThrough, encoding, codepage, this.nativeSignals, this.signalHandler, this.paused);
                        }
                        catch (Throwable t) {
                            Log.debug("Error creating JNA based terminal: ", t.getMessage(), t);
                            exception.addSuppressed(t);
                        }
                    }
                    if (terminal == null && tbs.hasJansiSupport()) {
                        try {
                            terminal = tbs.getJansiSupport().winSysTerminal(name, type2, ansiPassThrough, encoding, codepage, this.nativeSignals, this.signalHandler, this.paused);
                        }
                        catch (Throwable t) {
                            Log.debug("Error creating JANSI based terminal: ", t.getMessage(), t);
                            exception.addSuppressed(t);
                        }
                    }
                    if (terminal == null && exec.booleanValue() && (OSUtils.IS_CYGWIN || OSUtils.IS_MSYSTEM)) {
                        try {
                            if ("xterm".equals(type2) && this.type == null && System.getProperty(PROP_TYPE) == null) {
                                type2 = "xterm-256color";
                            }
                            terminal = new PosixSysTerminal(name, type2, tbs.getExecPty(), encoding, this.nativeSignals, this.signalHandler);
                        }
                        catch (IOException e) {
                            Log.debug("Error creating EXEC based terminal: ", e.getMessage(), e);
                            exception.addSuppressed(e);
                        }
                    }
                    if (!(terminal != null || jna.booleanValue() || jansi.booleanValue() || dumb != null && dumb.booleanValue())) {
                        throw new IllegalStateException("Unable to create a system terminal. On windows, either JNA or JANSI library is required.  Make sure to add one of those in the classpath.");
                    }
                } else {
                    Pty pty;
                    if (tbs.hasJnaSupport()) {
                        try {
                            pty = tbs.getJnaSupport().current();
                            terminal = new PosixSysTerminal(name, type2, pty, encoding, this.nativeSignals, this.signalHandler);
                        }
                        catch (Throwable t) {
                            Log.debug("Error creating JNA based terminal: ", t.getMessage(), t);
                            exception.addSuppressed(t);
                        }
                    }
                    if (terminal == null && tbs.hasJansiSupport()) {
                        try {
                            pty = tbs.getJansiSupport().current();
                            terminal = new PosixSysTerminal(name, type2, pty, encoding, this.nativeSignals, this.signalHandler);
                        }
                        catch (Throwable t) {
                            Log.debug("Error creating JANSI based terminal: ", t.getMessage(), t);
                            exception.addSuppressed(t);
                        }
                    }
                    if (terminal == null && exec.booleanValue()) {
                        try {
                            terminal = new PosixSysTerminal(name, type2, tbs.getExecPty(), encoding, this.nativeSignals, this.signalHandler);
                        }
                        catch (Throwable t) {
                            Log.debug("Error creating EXEC based terminal: ", t.getMessage(), t);
                            exception.addSuppressed(t);
                        }
                    }
                }
                if (terminal instanceof AbstractTerminal) {
                    AbstractTerminal t = terminal;
                    if (SYSTEM_TERMINAL.compareAndSet(null, t)) {
                        t.setOnClose(() -> SYSTEM_TERMINAL.compareAndSet(t, null));
                    } else {
                        exception.addSuppressed(new IllegalStateException("A system terminal is already running. Make sure to use the created system Terminal on the LineReaderBuilder if you're using one or that previously created system Terminals have been correctly closed."));
                        terminal.close();
                        terminal = null;
                    }
                }
            }
            if (terminal == null && (dumb == null || dumb.booleanValue())) {
                Boolean color = this.color;
                if (color == null) {
                    color = TerminalBuilder.getBoolean(PROP_DUMB_COLOR, false);
                    if (!color.booleanValue()) {
                        color = System.getenv("INSIDE_EMACS") != null;
                    }
                    if (!color.booleanValue()) {
                        String command = TerminalBuilder.getParentProcessCommand();
                        color = command != null && command.contains("idea");
                    }
                    if (!color.booleanValue()) {
                        color = tbs.isConsoleOutput() && System.getenv("TERM") != null;
                    }
                    if (!color.booleanValue() && dumb == null) {
                        if (Log.isDebugEnabled()) {
                            Log.warn("input is tty: ", tbs.isConsoleInput());
                            Log.warn("output is tty: ", tbs.isConsoleOutput());
                            Log.warn("Creating a dumb terminal", exception);
                        } else {
                            Log.warn("Unable to create a system terminal, creating a dumb terminal (enable debug logging for more information)");
                        }
                    }
                }
                terminal = new DumbTerminal(name, color != false ? "dumb-color" : "dumb", new FileInputStream(FileDescriptor.in), new FileOutputStream(FileDescriptor.out), encoding, this.signalHandler);
            }
            if (terminal == null) {
                throw exception;
            }
            return terminal;
        }
        if (jna.booleanValue()) {
            try {
                Pty pty = TerminalBuilder.load(JnaSupport.class).open(this.attributes, this.size);
                return new PosixPtyTerminal(name, type2, pty, this.in, this.out, encoding, this.signalHandler, this.paused);
            }
            catch (Throwable t) {
                Log.debug("Error creating JNA based terminal: ", t.getMessage(), t);
            }
        }
        if (jansi.booleanValue()) {
            try {
                Pty pty = TerminalBuilder.load(JansiSupport.class).open(this.attributes, this.size);
                return new PosixPtyTerminal(name, type2, pty, this.in, this.out, encoding, this.signalHandler, this.paused);
            }
            catch (Throwable t) {
                Log.debug("Error creating JANSI based terminal: ", t.getMessage(), t);
            }
        }
        return new ExternalTerminal(name, type2, this.in, this.out, encoding, this.signalHandler, this.paused, this.attributes, this.size);
    }

    private static String getParentProcessCommand() {
        try {
            Class<?> phClass = Class.forName("java.lang.ProcessHandle");
            Object current = phClass.getMethod("current", new Class[0]).invoke(null, new Object[0]);
            Object parent = ((Optional)phClass.getMethod("parent", new Class[0]).invoke(current, new Object[0])).orElse(null);
            Method infoMethod = phClass.getMethod("info", new Class[0]);
            Object info = infoMethod.invoke(parent, new Object[0]);
            Object command = ((Optional)infoMethod.getReturnType().getMethod("command", new Class[0]).invoke(info, new Object[0])).orElse(null);
            return command;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Boolean getBoolean(String name, Boolean def) {
        try {
            String str = System.getProperty(name);
            if (str != null) {
                return Boolean.parseBoolean(str);
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return def;
    }

    private static <S> S load(Class<S> clazz) {
        return ServiceLoader.load(clazz, clazz.getClassLoader()).iterator().next();
    }

    @Deprecated
    public static void setTerminalOverride(Terminal terminal) {
        TERMINAL_OVERRIDE.set(terminal);
    }

    private static class TerminalBuilderSupport {
        private JansiSupport jansiSupport = null;
        private JnaSupport jnaSupport = null;
        private boolean jnaFullSupport;
        private boolean jansiFullSupport;
        private Pty pty = null;
        private boolean consoleOutput;

        TerminalBuilderSupport(boolean jna, boolean jansi) {
            if (jna) {
                try {
                    this.jnaSupport = (JnaSupport)TerminalBuilder.load(JnaSupport.class);
                    this.consoleOutput = this.jnaSupport.isConsoleOutput();
                    this.jnaFullSupport = true;
                }
                catch (Throwable e) {
                    Log.debug("jnaSupport.isConsoleOutput(): ", e);
                }
            }
            if (jansi) {
                try {
                    this.jansiSupport = (JansiSupport)TerminalBuilder.load(JansiSupport.class);
                    this.consoleOutput = this.jansiSupport.isConsoleOutput();
                    this.jansiFullSupport = true;
                }
                catch (Throwable e) {
                    Log.debug("jansiSupport.isConsoleOutput(): ", e);
                }
            }
            if (!this.jnaFullSupport && !this.jansiFullSupport) {
                try {
                    this.pty = ExecPty.current();
                    this.consoleOutput = true;
                }
                catch (Exception e) {
                    Log.debug("ExecPty.current(): ", e);
                }
            }
        }

        public boolean isConsoleOutput() {
            return this.consoleOutput;
        }

        public boolean isConsoleInput() {
            if (this.jnaFullSupport) {
                return this.jnaSupport.isConsoleInput();
            }
            if (this.jansiFullSupport) {
                return this.jansiSupport.isConsoleInput();
            }
            return this.pty != null;
        }

        public boolean hasJnaSupport() {
            return this.jnaSupport != null;
        }

        public boolean hasJansiSupport() {
            return this.jansiSupport != null;
        }

        public JnaSupport getJnaSupport() {
            return this.jnaSupport;
        }

        public JansiSupport getJansiSupport() {
            return this.jansiSupport;
        }

        public Pty getExecPty() throws IOException {
            if (this.pty == null) {
                this.pty = ExecPty.current();
            }
            return this.pty;
        }
    }
}

