/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.assertions.Assertions;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public class JsonObject
implements Bson {
    private final String json;

    public JsonObject(String json2) {
        Assertions.notNull("Json", json2);
        boolean foundBrace = false;
        for (int i2 = 0; i2 < json2.length(); ++i2) {
            char c = json2.charAt(i2);
            if (c == '{') {
                foundBrace = true;
                break;
            }
            Assertions.isTrueArgument("json is a valid JSON object", Character.isWhitespace(c));
        }
        Assertions.isTrueArgument("json is a valid JSON object", foundBrace);
        this.json = json2;
    }

    public String getJson() {
        return this.json;
    }

    @Override
    public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry registry) {
        return new BsonDocumentWrapper<JsonObject>(this, registry.get(JsonObject.class));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonObject that = (JsonObject)o;
        return this.json.equals(that.getJson());
    }

    public int hashCode() {
        return this.json.hashCode();
    }

    public String toString() {
        return this.json;
    }
}

