/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.assertions.Assertions;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.ClassModel;
import org.bson.codecs.pojo.Convention;
import org.bson.codecs.pojo.Conventions;
import org.bson.codecs.pojo.IdGenerator;
import org.bson.codecs.pojo.IdPropertyModelHolder;
import org.bson.codecs.pojo.InstanceCreatorFactory;
import org.bson.codecs.pojo.PojoBuilderHelper;
import org.bson.codecs.pojo.PropertyModel;
import org.bson.codecs.pojo.PropertyModelBuilder;
import org.bson.codecs.pojo.TypeParameterMap;

public class ClassModelBuilder<T> {
    static final String ID_PROPERTY_NAME = "_id";
    private final List<PropertyModelBuilder<?>> propertyModelBuilders = new ArrayList();
    private IdGenerator<?> idGenerator;
    private InstanceCreatorFactory<T> instanceCreatorFactory;
    private Class<T> type;
    private Map<String, TypeParameterMap> propertyNameToTypeParameterMap = Collections.emptyMap();
    private List<Convention> conventions = Conventions.DEFAULT_CONVENTIONS;
    private List<Annotation> annotations = Collections.emptyList();
    private boolean discriminatorEnabled;
    private String discriminator;
    private String discriminatorKey;
    private String idPropertyName;

    ClassModelBuilder(Class<T> type2) {
        PojoBuilderHelper.configureClassModelBuilder(this, Assertions.notNull("type", type2));
    }

    public ClassModelBuilder<T> idGenerator(IdGenerator<?> idGenerator) {
        this.idGenerator = idGenerator;
        return this;
    }

    public IdGenerator<?> getIdGenerator() {
        return this.idGenerator;
    }

    public ClassModelBuilder<T> instanceCreatorFactory(InstanceCreatorFactory<T> instanceCreatorFactory) {
        this.instanceCreatorFactory = Assertions.notNull("instanceCreatorFactory", instanceCreatorFactory);
        return this;
    }

    public InstanceCreatorFactory<T> getInstanceCreatorFactory() {
        return this.instanceCreatorFactory;
    }

    public ClassModelBuilder<T> type(Class<T> type2) {
        this.type = Assertions.notNull("type", type2);
        return this;
    }

    public Class<T> getType() {
        return this.type;
    }

    public ClassModelBuilder<T> conventions(List<Convention> conventions) {
        this.conventions = Assertions.notNull("conventions", conventions);
        return this;
    }

    public List<Convention> getConventions() {
        return this.conventions;
    }

    public ClassModelBuilder<T> annotations(List<Annotation> annotations) {
        this.annotations = Assertions.notNull("annotations", annotations);
        return this;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public ClassModelBuilder<T> discriminator(String discriminator) {
        this.discriminator = discriminator;
        return this;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public ClassModelBuilder<T> discriminatorKey(String discriminatorKey) {
        this.discriminatorKey = discriminatorKey;
        return this;
    }

    public String getDiscriminatorKey() {
        return this.discriminatorKey;
    }

    public ClassModelBuilder<T> enableDiscriminator(boolean discriminatorEnabled) {
        this.discriminatorEnabled = discriminatorEnabled;
        return this;
    }

    public Boolean useDiscriminator() {
        return this.discriminatorEnabled;
    }

    public ClassModelBuilder<T> idPropertyName(String idPropertyName) {
        this.idPropertyName = idPropertyName;
        return this;
    }

    public String getIdPropertyName() {
        return this.idPropertyName;
    }

    public boolean removeProperty(String propertyName) {
        return this.propertyModelBuilders.remove(this.getProperty(Assertions.notNull("propertyName", propertyName)));
    }

    public PropertyModelBuilder<?> getProperty(String propertyName) {
        Assertions.notNull("propertyName", propertyName);
        for (PropertyModelBuilder<?> propertyModelBuilder : this.propertyModelBuilders) {
            if (!propertyModelBuilder.getName().equals(propertyName)) continue;
            return propertyModelBuilder;
        }
        return null;
    }

    public List<PropertyModelBuilder<?>> getPropertyModelBuilders() {
        return Collections.unmodifiableList(this.propertyModelBuilders);
    }

    public ClassModel<T> build() {
        ArrayList propertyModels = new ArrayList();
        PropertyModel idPropertyModel = null;
        PojoBuilderHelper.stateNotNull("type", this.type);
        for (Convention convention : this.conventions) {
            convention.apply(this);
        }
        PojoBuilderHelper.stateNotNull("instanceCreatorFactory", this.instanceCreatorFactory);
        if (this.discriminatorEnabled) {
            PojoBuilderHelper.stateNotNull("discriminatorKey", this.discriminatorKey);
            PojoBuilderHelper.stateNotNull("discriminator", this.discriminator);
        }
        for (PropertyModelBuilder propertyModelBuilder : this.propertyModelBuilders) {
            boolean isIdProperty = propertyModelBuilder.getName().equals(this.idPropertyName);
            if (isIdProperty) {
                propertyModelBuilder.readName(ID_PROPERTY_NAME).writeName(ID_PROPERTY_NAME);
            }
            PropertyModel model = propertyModelBuilder.build();
            propertyModels.add(model);
            if (!isIdProperty) continue;
            idPropertyModel = model;
        }
        this.validatePropertyModels(this.type.getSimpleName(), propertyModels);
        return new ClassModel<T>(this.type, this.propertyNameToTypeParameterMap, this.instanceCreatorFactory, this.discriminatorEnabled, this.discriminatorKey, this.discriminator, IdPropertyModelHolder.create(this.type, idPropertyModel, this.idGenerator), Collections.unmodifiableList(propertyModels));
    }

    public String toString() {
        return String.format("ClassModelBuilder{type=%s}", this.type);
    }

    Map<String, TypeParameterMap> getPropertyNameToTypeParameterMap() {
        return this.propertyNameToTypeParameterMap;
    }

    ClassModelBuilder<T> propertyNameToTypeParameterMap(Map<String, TypeParameterMap> propertyNameToTypeParameterMap) {
        this.propertyNameToTypeParameterMap = Collections.unmodifiableMap(new HashMap<String, TypeParameterMap>(propertyNameToTypeParameterMap));
        return this;
    }

    ClassModelBuilder<T> addProperty(PropertyModelBuilder<?> propertyModelBuilder) {
        this.propertyModelBuilders.add(Assertions.notNull("propertyModelBuilder", propertyModelBuilder));
        return this;
    }

    private void validatePropertyModels(String declaringClass, List<PropertyModel<?>> propertyModels) {
        HashMap<String, Integer> propertyNameMap = new HashMap<String, Integer>();
        HashMap<String, Integer> propertyReadNameMap = new HashMap<String, Integer>();
        HashMap<String, Integer> propertyWriteNameMap = new HashMap<String, Integer>();
        for (PropertyModel<?> propertyModel : propertyModels) {
            if (propertyModel.hasError()) {
                throw new CodecConfigurationException(propertyModel.getError());
            }
            this.checkForDuplicates("property", propertyModel.getName(), propertyNameMap, declaringClass);
            if (propertyModel.isReadable()) {
                this.checkForDuplicates("read property", propertyModel.getReadName(), propertyReadNameMap, declaringClass);
            }
            if (!propertyModel.isWritable()) continue;
            this.checkForDuplicates("write property", propertyModel.getWriteName(), propertyWriteNameMap, declaringClass);
        }
        if (this.idPropertyName != null && !propertyNameMap.containsKey(this.idPropertyName)) {
            throw new CodecConfigurationException(String.format("Invalid id property, property named '%s' can not be found.", this.idPropertyName));
        }
    }

    private void checkForDuplicates(String propertyType, String propertyName, Map<String, Integer> propertyNameMap, String declaringClass) {
        if (propertyNameMap.containsKey(propertyName)) {
            throw new CodecConfigurationException(String.format("Duplicate %s named '%s' found in %s.", propertyType, propertyName, declaringClass));
        }
        propertyNameMap.put(propertyName, 1);
    }
}

