/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.WriteListener;

public abstract class ServletOutputStream
extends OutputStream {
    private static final String LSTRING_FILE = "javax.servlet.LocalStrings";
    private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.LocalStrings");

    protected ServletOutputStream() {
    }

    public void print(String s2) throws IOException {
        if (s2 == null) {
            s2 = "null";
        }
        int len2 = s2.length();
        for (int i2 = 0; i2 < len2; ++i2) {
            char c = s2.charAt(i2);
            if ((c & 0xFF00) != 0) {
                String errMsg = lStrings.getString("err.not_iso8859_1");
                Object[] errArgs = new Object[]{Character.valueOf(c)};
                errMsg = MessageFormat.format(errMsg, errArgs);
                throw new CharConversionException(errMsg);
            }
            this.write(c);
        }
    }

    public void print(boolean b) throws IOException {
        String msg = b ? lStrings.getString("value.true") : lStrings.getString("value.false");
        this.print(msg);
    }

    public void print(char c) throws IOException {
        this.print(String.valueOf(c));
    }

    public void print(int i2) throws IOException {
        this.print(String.valueOf(i2));
    }

    public void print(long l) throws IOException {
        this.print(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.print(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public void println() throws IOException {
        this.print("\r\n");
    }

    public void println(String s2) throws IOException {
        this.print(s2);
        this.println();
    }

    public void println(boolean b) throws IOException {
        this.print(b);
        this.println();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.println();
    }

    public void println(int i2) throws IOException {
        this.print(i2);
        this.println();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.println();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.println();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.println();
    }

    public abstract boolean isReady();

    public abstract void setWriteListener(WriteListener var1);
}

