/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.jpower.kcp.netty.UkcpServerChannel;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.bootstrap.UkcpServerBootstrapConfig;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.util.AttributeKey;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UkcpServerBootstrap
extends AbstractBootstrap<UkcpServerBootstrap, UkcpServerChannel>
implements Cloneable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ServerBootstrap.class);
    private final Map<ChannelOption<?>, Object> childOptions = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> childAttrs = new ConcurrentHashMap();
    private final UkcpServerBootstrapConfig config = new UkcpServerBootstrapConfig(this);
    private volatile ChannelHandler childHandler;

    public UkcpServerBootstrap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UkcpServerBootstrap(UkcpServerBootstrap bootstrap) {
        super(bootstrap);
        this.childHandler = bootstrap.childHandler;
        Map<ChannelOption<?>, Object> map = bootstrap.childOptions;
        synchronized (map) {
            this.childOptions.putAll(bootstrap.childOptions);
        }
        this.childAttrs.putAll(bootstrap.childAttrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> UkcpServerBootstrap childOption(ChannelOption<T> childOption, T value) {
        ObjectUtil.checkNotNull(childOption, "childOption");
        Map<ChannelOption<?>, Object> map = this.childOptions;
        synchronized (map) {
            if (value == null) {
                this.childOptions.remove(childOption);
            } else {
                this.childOptions.put(childOption, value);
            }
        }
        return this;
    }

    public <T> UkcpServerBootstrap childAttr(AttributeKey<T> childKey, T value) {
        ObjectUtil.checkNotNull(childKey, "childKey");
        if (value == null) {
            this.childAttrs.remove(childKey);
        } else {
            this.childAttrs.put(childKey, value);
        }
        return this;
    }

    public UkcpServerBootstrap childHandler(ChannelHandler childHandler) {
        this.childHandler = ObjectUtil.checkNotNull(childHandler, "childHandler");
        return this;
    }

    @Override
    void init(Channel channel) {
        UkcpServerBootstrap.setChannelOptions(channel, this.newOptionsArray(), logger);
        UkcpServerBootstrap.setAttributes(channel, this.newAttributesArray());
        ChannelPipeline p = channel.pipeline();
        final ChannelHandler currentChildHandler = this.childHandler;
        final Map.Entry[] currentChildOptions = UkcpServerBootstrap.newOptionsArray(this.childOptions);
        final Map.Entry[] currentChildAttrs = UkcpServerBootstrap.newAttributesArray(this.childAttrs);
        p.addLast(new ChannelInitializer<Channel>(){

            @Override
            public void initChannel(final Channel ch) throws Exception {
                final ChannelPipeline pipeline = ch.pipeline();
                ChannelHandler handler = UkcpServerBootstrap.this.config.handler();
                if (handler != null) {
                    pipeline.addLast(handler);
                }
                ch.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        pipeline.addLast(new ServerUkcpBootstrapAcceptor(ch, currentChildHandler, currentChildOptions, currentChildAttrs));
                    }
                });
            }
        });
    }

    @Override
    public UkcpServerBootstrap validate() {
        super.validate();
        if (this.childHandler == null) {
            throw new IllegalStateException("childHandler not set");
        }
        return this;
    }

    @Override
    public UkcpServerBootstrap clone() {
        return new UkcpServerBootstrap(this);
    }

    final ChannelHandler childHandler() {
        return this.childHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Map<ChannelOption<?>, Object> childOptions() {
        Map<ChannelOption<?>, Object> map = this.childOptions;
        synchronized (map) {
            return UkcpServerBootstrap.copiedMap(this.childOptions);
        }
    }

    final Map<AttributeKey<?>, Object> childAttrs() {
        return UkcpServerBootstrap.copiedMap(this.childAttrs);
    }

    public final UkcpServerBootstrapConfig config() {
        return this.config;
    }

    private static class ServerUkcpBootstrapAcceptor
    extends ChannelInboundHandlerAdapter {
        private final ChannelHandler childHandler;
        private final Map.Entry<ChannelOption<?>, Object>[] childOptions;
        private final Map.Entry<AttributeKey<?>, Object>[] childAttrs;

        ServerUkcpBootstrapAcceptor(Channel channel, ChannelHandler childHandler, Map.Entry<ChannelOption<?>, Object>[] childOptions, Map.Entry<AttributeKey<?>, Object>[] childAttrs) {
            this.childHandler = childHandler;
            this.childOptions = childOptions;
            this.childAttrs = childAttrs;
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            Channel parent = ctx.channel();
            final Channel child = (Channel)msg;
            child.pipeline().addLast(this.childHandler);
            UkcpServerBootstrap.setChannelOptions(child, this.childOptions, logger);
            UkcpServerBootstrap.setAttributes(child, this.childAttrs);
            try {
                parent.eventLoop().register(child).addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            ServerUkcpBootstrapAcceptor.forceClose(child, future.cause());
                        }
                    }
                });
            }
            catch (Throwable t) {
                ServerUkcpBootstrapAcceptor.forceClose(child, t);
            }
        }

        private static void forceClose(Channel child, Throwable t) {
            child.unsafe().closeForcibly();
            logger.warn("Failed to register an accepted channel: {}", (Object)child, (Object)t);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ctx.fireExceptionCaught(cause);
        }
    }
}

