/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.plugin.rendering.vue;

import io.javalin.plugin.rendering.vue.JavalinVueKt;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VueDependencyResolver {
    private final Map<String, String> componentIdToOwnContent;
    private final Map<String, String> componentIdToDependencyContent;
    private final Pattern tagRegex = Pattern.compile("<\\s*([a-z0-9|-]*).*?>", 32);
    private final Pattern componentRegex = Pattern.compile("Vue.component\\s*\\(\\s*[\"|'](.*)[\"|']\\s*,.*");

    public VueDependencyResolver(Set<Path> paths) {
        this.componentIdToOwnContent = new HashMap<String, String>();
        this.componentIdToDependencyContent = new HashMap<String, String>();
        paths.stream().filter(JavalinVueKt::isVueFile).forEach(path -> {
            String fileContent = JavalinVueKt.readText(path);
            Matcher matcher = this.componentRegex.matcher(fileContent);
            while (matcher.find()) {
                this.componentIdToOwnContent.put(matcher.group(1), fileContent);
            }
        });
    }

    public String resolve(String componentId) {
        if (!this.componentIdToOwnContent.containsKey(componentId)) {
            throw new IllegalArgumentException(String.format("Component %s not found", componentId));
        }
        if (this.componentIdToDependencyContent.containsKey(componentId)) {
            return this.componentIdToDependencyContent.get(componentId);
        }
        Set<String> dependencies = this.resolveTransitiveDependencies(componentId);
        StringBuilder builder = new StringBuilder();
        dependencies.forEach(dependency -> {
            builder.append("<!-- ").append((String)dependency).append("-->\n");
            builder.append(this.componentIdToOwnContent.get(dependency));
            builder.append("\n");
        });
        String allDependencies = builder.toString();
        this.componentIdToDependencyContent.put(componentId, allDependencies);
        return allDependencies;
    }

    private Set<String> resolveTransitiveDependencies(String componentId) {
        HashSet<String> requiredComponents = new HashSet<String>();
        requiredComponents.add(componentId);
        Set<String> directDependencies = this.resolveDirectDependencies(componentId);
        requiredComponents.addAll(directDependencies);
        directDependencies.forEach(dependency -> requiredComponents.addAll(this.resolveTransitiveDependencies((String)dependency)));
        return requiredComponents;
    }

    private Set<String> resolveDirectDependencies(String componentId) {
        HashSet<String> dependencies = new HashSet<String>();
        String componentContent = this.componentIdToOwnContent.get(componentId);
        Matcher matcher = this.tagRegex.matcher(componentContent);
        while (matcher.find()) {
            String match2 = matcher.group(1);
            if (match2.equals(componentId) || !this.componentIdToOwnContent.containsKey(match2)) continue;
            dependencies.add(match2);
        }
        return dependencies;
    }
}

