/*
 * Decompiled with CFR 0.152.
 */
package io.javalin;

import io.javalin.apibuilder.ApiBuilder;
import io.javalin.apibuilder.EndpointGroup;
import io.javalin.core.JavalinConfig;
import io.javalin.core.JavalinServer;
import io.javalin.core.JettyUtil;
import io.javalin.core.event.EventListener;
import io.javalin.core.event.EventManager;
import io.javalin.core.event.HandlerMetaInfo;
import io.javalin.core.event.JavalinEvent;
import io.javalin.core.event.WsHandlerMetaInfo;
import io.javalin.core.security.Role;
import io.javalin.core.util.Util;
import io.javalin.http.ErrorMapperKt;
import io.javalin.http.ExceptionHandler;
import io.javalin.http.Handler;
import io.javalin.http.HandlerType;
import io.javalin.http.JavalinServlet;
import io.javalin.http.sse.SseClient;
import io.javalin.http.sse.SseHandler;
import io.javalin.websocket.JavalinWsServlet;
import io.javalin.websocket.WsExceptionHandler;
import io.javalin.websocket.WsHandler;
import io.javalin.websocket.WsHandlerType;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Javalin {
    public static Logger log = LoggerFactory.getLogger(Javalin.class);
    public JavalinConfig config = new JavalinConfig();
    protected JavalinServer server;
    protected JavalinWsServlet wsServlet;
    protected JavalinServlet servlet = new JavalinServlet(this.config);
    protected EventManager eventManager = new EventManager();

    protected Javalin() {
        this.server = new JavalinServer(this.config);
        this.wsServlet = new JavalinWsServlet(this.config, this.servlet);
    }

    public Javalin(JavalinServer server, JavalinWsServlet wsServlet) {
        this.server = server;
        this.wsServlet = wsServlet;
    }

    public static Javalin create() {
        return Javalin.create(JavalinConfig.noopConfig);
    }

    public static Javalin create(Consumer<JavalinConfig> config) {
        Javalin app = new Javalin();
        JavalinConfig.applyUserConfig(app, app.config, config);
        if (app.config.logIfServerNotStarted) {
            Util.logIfServerNotStarted(app.server);
        }
        return app;
    }

    public static Javalin createStandalone(Consumer<JavalinConfig> config) {
        Javalin app = new Javalin(null, null);
        JavalinConfig.applyUserConfig(app, app.config, config);
        return app;
    }

    public static Javalin createStandalone() {
        return Javalin.createStandalone(JavalinConfig.noopConfig);
    }

    public JavalinServlet servlet() {
        return this.servlet;
    }

    public JavalinWsServlet wsServlet() {
        return this.wsServlet;
    }

    @Nullable
    public JavalinServer server() {
        return this.server;
    }

    public Javalin start(String host, int port) {
        this.server.setServerHost(host);
        return this.start(port);
    }

    public Javalin start(int port) {
        this.server.setServerPort(port);
        return this.start();
    }

    public Javalin start() {
        Util.logJavalinBanner(this.config.showJavalinBanner);
        JettyUtil.disableJettyLogger();
        long startupTimer = System.currentTimeMillis();
        if (this.server.getStarted()) {
            String message = "Server already started. If you are trying to call start() on an instance of Javalin that was stopped using stop(), please create a new instance instead.";
            throw new IllegalStateException(message);
        }
        this.server.setStarted(true);
        Util.printHelpfulMessageIfLoggerIsMissing();
        this.eventManager.fireEvent(JavalinEvent.SERVER_STARTING);
        try {
            log.info("Starting Javalin ...");
            this.server.start(this.wsServlet);
            log.info("Javalin started in " + (System.currentTimeMillis() - startupTimer) + "ms \\o/");
            this.eventManager.fireEvent(JavalinEvent.SERVER_STARTED);
        }
        catch (Exception e) {
            log.error("Failed to start Javalin");
            this.eventManager.fireEvent(JavalinEvent.SERVER_START_FAILED);
            if (Boolean.TRUE.equals(this.server.server().getAttribute("is-default-server"))) {
                this.stop();
            }
            if (e.getMessage() != null && e.getMessage().contains("Failed to bind to")) {
                throw new RuntimeException("Port already in use. Make sure no other process is using port " + this.server.getServerPort() + " and try again.", e);
            }
            if (e.getMessage() != null && e.getMessage().contains("Permission denied")) {
                throw new RuntimeException("Port 1-1023 require elevated privileges (process must be started by admin).", e);
            }
            throw new RuntimeException(e);
        }
        return this;
    }

    public Javalin stop() {
        log.info("Stopping Javalin ...");
        this.eventManager.fireEvent(JavalinEvent.SERVER_STOPPING);
        try {
            this.server.server().stop();
        }
        catch (Exception e) {
            log.error("Javalin failed to stop gracefully", e);
        }
        log.info("Javalin has stopped");
        this.eventManager.fireEvent(JavalinEvent.SERVER_STOPPED);
        return this;
    }

    public Javalin events(Consumer<EventListener> listener) {
        EventListener eventListener = new EventListener(this.eventManager);
        listener.accept(eventListener);
        return this;
    }

    public int port() {
        return this.server.getServerPort();
    }

    public Javalin attribute(Class clazz, Object obj) {
        this.config.inner.appAttributes.put(clazz, obj);
        return this;
    }

    public <T> T attribute(Class<T> clazz) {
        return (T)this.config.inner.appAttributes.get(clazz);
    }

    public Javalin routes(@NotNull EndpointGroup endpointGroup) {
        ApiBuilder.setStaticJavalin(this);
        try {
            endpointGroup.addEndpoints();
        }
        finally {
            ApiBuilder.clearStaticJavalin();
        }
        return this;
    }

    public <T extends Exception> Javalin exception(@NotNull Class<T> exceptionClass, @NotNull ExceptionHandler<? super T> exceptionHandler) {
        this.servlet.getExceptionMapper().getHandlers().put(exceptionClass, exceptionHandler);
        return this;
    }

    public Javalin error(int statusCode, @NotNull Handler handler) {
        this.servlet.getErrorMapper().getErrorHandlerMap().put(statusCode, handler);
        return this;
    }

    public Javalin error(int statusCode, @NotNull String contentType, @NotNull Handler handler) {
        return this.error(statusCode, ErrorMapperKt.contentTypeWrap(contentType, handler));
    }

    public Javalin addHandler(@NotNull HandlerType handlerType, @NotNull String path, @NotNull Handler handler, @NotNull Set<Role> roles) {
        if (Util.isNonSubPathWildcard(path)) {
            String basePath = path.substring(0, path.length() - 1);
            this.addHandler(handlerType, basePath, handler, roles);
            return this.addHandler(handlerType, basePath + "/*", handler, roles);
        }
        this.servlet.addHandler(handlerType, path, handler, roles);
        this.eventManager.fireHandlerAddedEvent(new HandlerMetaInfo(handlerType, Util.prefixContextPath(this.servlet.getConfig().contextPath, path), handler, roles));
        return this;
    }

    public Javalin addHandler(@NotNull HandlerType httpMethod, @NotNull String path, @NotNull Handler handler) {
        return this.addHandler(httpMethod, path, handler, new HashSet<Role>());
    }

    public Javalin get(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.GET, path, handler);
    }

    public Javalin post(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.POST, path, handler);
    }

    public Javalin put(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.PUT, path, handler);
    }

    public Javalin patch(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.PATCH, path, handler);
    }

    public Javalin delete(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.DELETE, path, handler);
    }

    public Javalin head(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.HEAD, path, handler);
    }

    public Javalin options(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.OPTIONS, path, handler);
    }

    public Javalin get(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        return this.addHandler(HandlerType.GET, path, handler, permittedRoles);
    }

    public Javalin post(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        return this.addHandler(HandlerType.POST, path, handler, permittedRoles);
    }

    public Javalin put(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        return this.addHandler(HandlerType.PUT, path, handler, permittedRoles);
    }

    public Javalin patch(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        return this.addHandler(HandlerType.PATCH, path, handler, permittedRoles);
    }

    public Javalin delete(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        return this.addHandler(HandlerType.DELETE, path, handler, permittedRoles);
    }

    public Javalin head(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        return this.addHandler(HandlerType.HEAD, path, handler, permittedRoles);
    }

    public Javalin options(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        return this.addHandler(HandlerType.OPTIONS, path, handler, permittedRoles);
    }

    public Javalin sse(@NotNull String path, @NotNull Consumer<SseClient> client) {
        return this.sse(path, client, new HashSet<Role>());
    }

    public Javalin sse(@NotNull String path, @NotNull Consumer<SseClient> client, @NotNull Set<Role> permittedRoles) {
        return this.get(path, new SseHandler(client), permittedRoles);
    }

    public Javalin before(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.BEFORE, path, handler);
    }

    public Javalin before(@NotNull Handler handler) {
        return this.before("*", handler);
    }

    public Javalin after(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.AFTER, path, handler);
    }

    public Javalin after(@NotNull Handler handler) {
        return this.after("*", handler);
    }

    public <T extends Exception> Javalin wsException(@NotNull Class<T> exceptionClass, @NotNull WsExceptionHandler<? super T> exceptionHandler) {
        this.wsServlet.getWsExceptionMapper().getHandlers().put(exceptionClass, exceptionHandler);
        return this;
    }

    private Javalin addWsHandler(@NotNull WsHandlerType handlerType, @NotNull String path, @NotNull Consumer<WsHandler> wsHandler, @NotNull Set<Role> roles) {
        this.wsServlet.addHandler(handlerType, path, wsHandler, roles);
        this.eventManager.fireWsHandlerAddedEvent(new WsHandlerMetaInfo(handlerType, Util.prefixContextPath(this.servlet.getConfig().contextPath, path), wsHandler, roles));
        return this;
    }

    private Javalin addWsHandler(@NotNull WsHandlerType handlerType, @NotNull String path, @NotNull Consumer<WsHandler> wsHandler) {
        return this.addWsHandler(handlerType, path, wsHandler, new HashSet<Role>());
    }

    public Javalin ws(@NotNull String path, @NotNull Consumer<WsHandler> ws) {
        return this.ws(path, ws, new HashSet<Role>());
    }

    public Javalin ws(@NotNull String path, @NotNull Consumer<WsHandler> ws, @NotNull Set<Role> permittedRoles) {
        return this.addWsHandler(WsHandlerType.WEBSOCKET, path, ws, permittedRoles);
    }

    public Javalin wsBefore(@NotNull String path, @NotNull Consumer<WsHandler> wsHandler) {
        return this.addWsHandler(WsHandlerType.WS_BEFORE, path, wsHandler);
    }

    public Javalin wsBefore(@NotNull Consumer<WsHandler> wsHandler) {
        return this.wsBefore("*", wsHandler);
    }

    public Javalin wsAfter(@NotNull String path, @NotNull Consumer<WsHandler> wsHandler) {
        return this.addWsHandler(WsHandlerType.WS_AFTER, path, wsHandler);
    }

    public Javalin wsAfter(@NotNull Consumer<WsHandler> wsHandler) {
        return this.wsAfter("*", wsHandler);
    }
}

