/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.utils;

import ch.qos.logback.classic.Logger;
import emu.grasscutter.Config;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.utils.Position;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.DayOfWeek;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.Random;

public final class Utils {
    public static final Random random = new Random();
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();

    public static int randomRange(int min2, int max2) {
        return random.nextInt(max2 - min2 + 1) + min2;
    }

    public static float randomFloatRange(float min2, float max2) {
        return random.nextFloat() * (max2 - min2) + min2;
    }

    public static double getDist(Position pos1, Position pos2) {
        double xs = pos1.getX() - pos2.getX();
        xs *= xs;
        double ys = pos1.getY() - pos2.getY();
        ys *= ys;
        double zs = pos1.getZ() - pos2.getZ();
        zs *= zs;
        return Math.sqrt(xs + zs + ys);
    }

    public static int getCurrentSeconds() {
        return (int)((double)System.currentTimeMillis() / 1000.0);
    }

    public static String lowerCaseFirstChar(String s2) {
        StringBuilder sb = new StringBuilder(s2);
        sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        return sb.toString();
    }

    public static String toString(InputStream inputStream) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = bis.read();
        while (result != -1) {
            buf.write((byte)result);
            result = bis.read();
        }
        return buf.toString();
    }

    public static void logByteArray(byte[] array) {
        ByteBuf b = Unpooled.wrappedBuffer(array);
        Grasscutter.getLogger().info("\n" + ByteBufUtil.prettyHexDump(b));
        b.release();
    }

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String bytesToHex(ByteBuf buf) {
        return Utils.bytesToHex(Utils.byteBufToArray(buf));
    }

    public static byte[] byteBufToArray(ByteBuf buf) {
        byte[] bytes = new byte[buf.capacity()];
        buf.getBytes(0, bytes);
        return bytes;
    }

    public static int abilityHash(String str) {
        int v7 = 0;
        int v8 = 0;
        while (v8 < str.length()) {
            v7 = str.charAt(v8++) + 131 * v7;
        }
        return v7;
    }

    public static String toFilePath(String path) {
        return path.replace("/", File.separator);
    }

    public static boolean fileExists(String path) {
        return new File(path).exists();
    }

    public static boolean createFolder(String path) {
        return new File(path).mkdirs();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFromResources(String resource, String destination) {
        try (InputStream stream = Grasscutter.class.getResourceAsStream(resource);){
            if (stream == null) {
                Grasscutter.getLogger().warn("Could not find resource: " + resource);
                boolean bl2 = false;
                return bl2;
            }
            Files.copy(stream, new File(destination).toPath(), StandardCopyOption.REPLACE_EXISTING);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Grasscutter.getLogger().warn("Unable to copy resource " + resource + " to " + destination, e);
            return false;
        }
    }

    public static <T> T requireNonNullElseGet(T nonNull, T fallback) {
        return nonNull != null ? nonNull : fallback;
    }

    public static void logObject(Object object) {
        String asJson = Grasscutter.getGsonFactory().toJson(object);
        Grasscutter.getLogger().info(asJson);
    }

    public static void startupCheck() {
        Config config = Grasscutter.getConfig();
        Logger logger = Grasscutter.getLogger();
        boolean exit = false;
        String resourcesFolder = config.RESOURCE_FOLDER;
        String dataFolder = config.DATA_FOLDER;
        if (!Utils.fileExists(resourcesFolder)) {
            logger.info("Creating resources folder...");
            logger.info("Place a copy of 'BinOutput' and 'ExcelBinOutput' in the resources folder.");
            Utils.createFolder(resourcesFolder);
            exit = true;
        }
        if (!Utils.fileExists(resourcesFolder + "BinOutput") || !Utils.fileExists(resourcesFolder + "ExcelBinOutput")) {
            logger.info("Place a copy of 'BinOutput' and 'ExcelBinOutput' in the resources folder.");
            exit = true;
        }
        if (!Utils.fileExists(dataFolder)) {
            Utils.createFolder(dataFolder);
        }
        if (exit) {
            System.exit(1);
        }
    }

    public static int GetNextTimestampOfThisHour(int hour, String timeZone, int param) {
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneId.of(timeZone));
        for (int i2 = 0; i2 < param; ++i2) {
            zonedDateTime = zonedDateTime.getHour() < hour ? zonedDateTime.withHour(hour).withMinute(0).withSecond(0) : zonedDateTime.plusDays(1L).withHour(hour).withMinute(0).withSecond(0);
        }
        return (int)zonedDateTime.toInstant().atZone(ZoneOffset.UTC).toEpochSecond();
    }

    public static int GetNextTimestampOfThisHourInNextWeek(int hour, String timeZone, int param) {
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneId.of(timeZone));
        for (int i2 = 0; i2 < param; ++i2) {
            zonedDateTime = zonedDateTime.getDayOfWeek() == DayOfWeek.MONDAY && zonedDateTime.getHour() < hour ? ZonedDateTime.now(ZoneId.of(timeZone)).withHour(hour).withMinute(0).withSecond(0) : zonedDateTime.with(TemporalAdjusters.next(DayOfWeek.MONDAY)).withHour(hour).withMinute(0).withSecond(0);
        }
        return (int)zonedDateTime.toInstant().atZone(ZoneOffset.UTC).toEpochSecond();
    }

    public static int GetNextTimestampOfThisHourInNextMonth(int hour, String timeZone, int param) {
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneId.of(timeZone));
        for (int i2 = 0; i2 < param; ++i2) {
            zonedDateTime = zonedDateTime.getDayOfMonth() == 1 && zonedDateTime.getHour() < hour ? ZonedDateTime.now(ZoneId.of(timeZone)).withHour(hour).withMinute(0).withSecond(0) : zonedDateTime.with(TemporalAdjusters.firstDayOfNextMonth()).withHour(hour).withMinute(0).withSecond(0);
        }
        return (int)zonedDateTime.toInstant().atZone(ZoneOffset.UTC).toEpochSecond();
    }
}

