/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.tools;

import com.google.gson.reflect.TypeToken;
import emu.grasscutter.GameConstants;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.GameResource;
import emu.grasscutter.data.ResourceLoader;
import emu.grasscutter.data.def.AvatarData;
import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.data.def.MonsterData;
import emu.grasscutter.data.def.SceneData;
import emu.grasscutter.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public final class Tools {
    public static void createGmHandbook() throws Exception {
        Map map;
        ResourceLoader.loadResources();
        try (InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(Utils.toFilePath(Grasscutter.getConfig().RESOURCE_FOLDER + "TextMap/TextMapEN.json")), StandardCharsets.UTF_8);){
            map = (Map)Grasscutter.getGsonFactory().fromJson((Reader)fileReader, new TypeToken<Map<Long, String>>(){}.getType());
        }
        String fileName = "./GM Handbook.txt";
        try (PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), StandardCharsets.UTF_8), false);){
            GameResource data;
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            writer.println("// Grasscutter " + GameConstants.VERSION + " GM Handbook");
            writer.println("// Created " + dtf.format(now) + System.lineSeparator() + System.lineSeparator());
            ArrayList<Integer> list = new ArrayList<Integer>(GameData.getAvatarDataMap().keySet());
            Collections.sort(list);
            writer.println("// Avatars");
            for (Integer id : list) {
                data = GameData.getAvatarDataMap().get(id);
                writer.println(((AvatarData)data).getId() + " : " + (String)map.get(((AvatarData)data).getNameTextMapHash()));
            }
            writer.println();
            list = new ArrayList<Integer>(GameData.getItemDataMap().keySet());
            Collections.sort(list);
            writer.println("// Items");
            for (Integer id : list) {
                data = GameData.getItemDataMap().get(id);
                writer.println(((ItemData)data).getId() + " : " + (String)map.get(((ItemData)data).getNameTextMapHash()));
            }
            writer.println();
            writer.println("// Scenes");
            list = new ArrayList<Integer>(GameData.getSceneDataMap().keySet());
            Collections.sort(list);
            for (Integer id : list) {
                data = GameData.getSceneDataMap().get(id);
                writer.println(((SceneData)data).getId() + " : " + ((SceneData)data).getScriptData());
            }
            writer.println();
            writer.println("// Monsters");
            list = new ArrayList<Integer>(GameData.getMonsterDataMap().keySet());
            Collections.sort(list);
            for (Integer id : list) {
                data = GameData.getMonsterDataMap().get(id);
                writer.println(((MonsterData)data).getId() + " : " + (String)map.get(((MonsterData)data).getNameTextMapHash()));
            }
        }
        Grasscutter.getLogger().info("GM Handbook generated!");
    }

    public static void createGachaMapping() throws Exception {
        Map map;
        ResourceLoader.loadResources();
        try (InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(Utils.toFilePath(Grasscutter.getConfig().RESOURCE_FOLDER + "TextMap/TextMapEN.json")), StandardCharsets.UTF_8);){
            map = (Map)Grasscutter.getGsonFactory().fromJson((Reader)fileReader, new TypeToken<Map<Long, String>>(){}.getType());
        }
        String fileName = Grasscutter.getConfig().RESOURCE_FOLDER + "/gcstatic";
        File folder = new File(fileName);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        fileName = fileName + "/mappings.js";
        try (PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), StandardCharsets.UTF_8), false);){
            GameResource data;
            ArrayList<Integer> list = new ArrayList<Integer>(GameData.getAvatarDataMap().keySet());
            Collections.sort(list);
            writer.println("mappings = {\"en-us\": {");
            boolean first = true;
            for (Integer id : list) {
                data = GameData.getAvatarDataMap().get(id);
                int avatarID = ((AvatarData)data).getId();
                if (avatarID >= 11000000) continue;
                if (first) {
                    first = false;
                } else {
                    writer.print(",");
                }
                writer.println("\"" + (avatarID % 1000 + 1000) + "\" : [\"" + (String)map.get(((AvatarData)data).getNameTextMapHash()) + "(Avatar)\", \"" + (switch (((AvatarData)data).getQualityType()) {
                    case "QUALITY_PURPLE" -> "purple";
                    case "QUALITY_ORANGE" -> "yellow";
                    default -> "blue";
                }) + "\"]");
            }
            writer.println();
            list = new ArrayList<Integer>(GameData.getItemDataMap().keySet());
            Collections.sort(list);
            block25: for (Integer id : list) {
                String color;
                data = GameData.getItemDataMap().get(id);
                if (((ItemData)data).getId() <= 11101 || ((ItemData)data).getId() >= 20000) continue;
                switch (((ItemData)data).getRankLevel()) {
                    case 3: {
                        color = "blue";
                        break;
                    }
                    case 4: {
                        color = "purple";
                        break;
                    }
                    case 5: {
                        color = "yellow";
                        break;
                    }
                    default: {
                        continue block25;
                    }
                }
                writer.println(",\"" + ((ItemData)data).getId() + "\" : [\"" + ((String)map.get(((ItemData)data).getNameTextMapHash())).replaceAll("\"", "") + "(Weapon)\",\"" + color + "\"]");
            }
            writer.println(",\"200\": \"Standard\", \"301\": \"Avatar Event\", \"302\": \"Weapon event\"");
            writer.println("}\n}");
        }
        Grasscutter.getLogger().info("Mappings generated!");
    }
}

