/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.packet.recv;

import emu.grasscutter.data.GameData;
import emu.grasscutter.data.common.RewardItemData;
import emu.grasscutter.data.def.PlayerLevelData;
import emu.grasscutter.data.def.RewardData;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.props.ActionReason;
import emu.grasscutter.net.packet.Opcodes;
import emu.grasscutter.net.packet.PacketHandler;
import emu.grasscutter.net.proto.TakePlayerLevelRewardReqOuterClass;
import emu.grasscutter.server.game.GameSession;
import emu.grasscutter.server.packet.send.PacketItemAddHintNotify;
import emu.grasscutter.server.packet.send.PacketTakePlayerLevelRewardRsp;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

@Opcodes(value=151)
public class HandlerTakePlayerLevelRewardReq
extends PacketHandler {
    @Override
    public void handle(GameSession session, byte[] header, byte[] payload) throws Exception {
        TakePlayerLevelRewardReqOuterClass.TakePlayerLevelRewardReq req = TakePlayerLevelRewardReqOuterClass.TakePlayerLevelRewardReq.parseFrom(payload);
        int level = req.getLevel();
        int rewardId = ((PlayerLevelData)GameData.getPlayerLevelDataMap().get(level)).getRewardId();
        if (rewardId != 0) {
            List<RewardItemData> rewardItems = ((RewardData)GameData.getRewardDataMap().get(rewardId)).getRewardItemList();
            LinkedList<GameItem> items = new LinkedList<GameItem>();
            for (RewardItemData rewardItem : rewardItems) {
                if (rewardItem == null || rewardItem.getItemId() == 0) continue;
                items.add(new GameItem(rewardItem.getItemId(), rewardItem.getItemCount()));
            }
            session.getPlayer().getInventory().addItems(items);
            session.getPlayer().sendPacket(new PacketItemAddHintNotify(items, ActionReason.PlayerUpgradeReward));
            Set<Integer> rewardedLevels = session.getPlayer().getRewardedLevels();
            rewardedLevels.add(level);
            session.getPlayer().setRewardedLevels(rewardedLevels);
        }
        session.send(new PacketTakePlayerLevelRewardRsp(level, rewardId));
    }
}

