/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.packet.recv;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.command.commands.SendMailCommand;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.AvatarSkillDepotData;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.mail.Mail;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.net.packet.BasePacket;
import emu.grasscutter.net.packet.Opcodes;
import emu.grasscutter.net.packet.PacketHandler;
import emu.grasscutter.net.proto.SetPlayerBornDataReqOuterClass;
import emu.grasscutter.server.event.game.PlayerCreationEvent;
import emu.grasscutter.server.game.GameSession;
import java.util.Arrays;

@Opcodes(value=155)
public class HandlerSetPlayerBornDataReq
extends PacketHandler {
    @Override
    public void handle(GameSession session, byte[] header, byte[] payload) throws Exception {
        int startingSkillDepot;
        SetPlayerBornDataReqOuterClass.SetPlayerBornDataReq req = SetPlayerBornDataReqOuterClass.SetPlayerBornDataReq.parseFrom(payload);
        int avatarId = req.getAvatarId();
        if (avatarId == 10000005) {
            startingSkillDepot = 504;
        } else if (avatarId == 10000007) {
            startingSkillDepot = 704;
        } else {
            return;
        }
        String nickname = req.getNickName();
        if (nickname == null) {
            nickname = "Traveler";
        }
        PlayerCreationEvent event = new PlayerCreationEvent(session, Player.class);
        event.call();
        Player player = event.getPlayerClass().getDeclaredConstructor(GameSession.class).newInstance(session);
        player.setNickname(nickname);
        try {
            DatabaseHelper.createPlayer(player, session.getAccount().getPlayerUid());
            if (player.getAvatars().getAvatarCount() == 0) {
                Avatar mainCharacter = new Avatar(avatarId);
                mainCharacter.setSkillDepot((AvatarSkillDepotData)GameData.getAvatarSkillDepotDataMap().get(startingSkillDepot));
                player.addAvatar(mainCharacter);
                player.setMainCharacterId(avatarId);
                player.setHeadImage(avatarId);
                player.getTeamManager().getCurrentSinglePlayerTeamInfo().getAvatars().add(mainCharacter.getAvatarId());
                player.save();
            }
            session.getAccount().setPlayerId(player.getUid());
            session.getAccount().save();
            session.setPlayer(player);
            session.getPlayer().onLogin();
            session.setState(GameSession.SessionState.ACTIVE);
            session.send(new BasePacket(146));
            char d = 'G';
            char e = 'r';
            char z = 'a';
            char u = 'c';
            char s2 = 't';
            SendMailCommand.MailBuilder mailBuilder = new SendMailCommand.MailBuilder(player.getUid(), new Mail());
            mailBuilder.mail.mailContent.title = String.format("W%sl%som%s to %s%s%s%s%s%s%s%s%s%s%s!", Character.valueOf(DatabaseHelper.AWJVN), Character.valueOf(u), Character.valueOf(DatabaseHelper.AWJVN), Character.valueOf(d), Character.valueOf(e), Character.valueOf(z), Character.valueOf(GameData.EJWOA), Character.valueOf(GameData.EJWOA), Character.valueOf(u), Character.valueOf('u'), Character.valueOf(s2), Character.valueOf(s2), Character.valueOf(DatabaseHelper.AWJVN), Character.valueOf(e));
            mailBuilder.mail.mailContent.sender = String.format("L%swnmow%s%s @ Gi%sH%sb", Character.valueOf(z), Character.valueOf(DatabaseHelper.AWJVN), Character.valueOf(e), Character.valueOf(s2), Character.valueOf('u'));
            mailBuilder.mail.mailContent.content = Grasscutter.getConfig().GameServer.WelcomeMailContent;
            mailBuilder.mail.itemList.addAll(Arrays.asList(Grasscutter.getConfig().GameServer.WelcomeMailItems));
            mailBuilder.mail.importance = 1;
            player.sendMail(mailBuilder.mail);
        }
        catch (Exception e) {
            Grasscutter.getLogger().error("Error creating player object: ", e);
            session.close();
        }
    }
}

