/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.packet.recv;

import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.net.packet.BasePacket;
import emu.grasscutter.net.packet.Opcodes;
import emu.grasscutter.net.packet.PacketHandler;
import emu.grasscutter.net.proto.PlayerLoginReqOuterClass;
import emu.grasscutter.server.game.GameSession;
import emu.grasscutter.server.packet.send.PacketPlayerLoginRsp;

@Opcodes(value=110)
public class HandlerPlayerLoginReq
extends PacketHandler {
    @Override
    public void handle(GameSession session, byte[] header, byte[] payload) throws Exception {
        if (session.getAccount() == null) {
            return;
        }
        PlayerLoginReqOuterClass.PlayerLoginReq req = PlayerLoginReqOuterClass.PlayerLoginReq.parseFrom(payload);
        if (!req.getToken().equals(session.getAccount().getToken())) {
            return;
        }
        Player player = DatabaseHelper.getPlayerById(session.getAccount().getPlayerUid());
        if (player == null) {
            session.setState(GameSession.SessionState.PICKING_CHARACTER);
            session.send(new BasePacket(174));
        } else {
            session.setPlayer(player);
            session.getPlayer().onLogin();
            session.setState(GameSession.SessionState.ACTIVE);
        }
        session.send(new PacketPlayerLoginRsp(session));
    }
}

