/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.packet.recv;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.net.packet.Opcodes;
import emu.grasscutter.net.packet.PacketHandler;
import emu.grasscutter.net.proto.MarkMapReqOuterClass;
import emu.grasscutter.server.game.GameSession;
import emu.grasscutter.server.packet.send.PacketSceneEntityAppearNotify;

@Opcodes(value=3053)
public class HandlerMarkMapReq
extends PacketHandler {
    private static boolean isInt(String str) {
        try {
            int x = Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void handle(GameSession session, byte[] header, byte[] payload) throws Exception {
        MarkMapReqOuterClass.MarkMapReq req = MarkMapReqOuterClass.MarkMapReq.parseFrom(payload);
        if (req.getOp() != MarkMapReqOuterClass.MarkMapReq.Operation.ADD) {
            return;
        }
        session.getPlayer().getPos().setX(req.getMark().getPos().getX());
        session.getPlayer().getPos().setZ(req.getMark().getPos().getZ());
        session.getPlayer().getPos().setY(HandlerMarkMapReq.isInt(req.getMark().getName()) ? (float)Integer.parseInt(req.getMark().getName()) : 300.0f);
        Grasscutter.getLogger().info("Player [" + session.getPlayer().getUid() + ":" + session.getPlayer().getNickname() + "] tp to " + session.getPlayer().getPos() + " Scene id: " + req.getMark().getSceneId());
        if (req.getMark().getSceneId() != session.getPlayer().getSceneId()) {
            session.getPlayer().getWorld().transferPlayerToScene(session.getPlayer(), req.getMark().getSceneId(), session.getPlayer().getPos());
        } else {
            session.getPlayer().getScene().broadcastPacket(new PacketSceneEntityAppearNotify(session.getPlayer()));
        }
    }
}

