/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.packet.recv;

import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.Account;
import emu.grasscutter.net.packet.Opcodes;
import emu.grasscutter.net.packet.PacketHandler;
import emu.grasscutter.net.proto.GetPlayerTokenReqOuterClass;
import emu.grasscutter.server.game.GameSession;
import emu.grasscutter.server.packet.send.PacketGetPlayerTokenRsp;

@Opcodes(value=160)
public class HandlerGetPlayerTokenReq
extends PacketHandler {
    @Override
    public void handle(GameSession session, byte[] header, byte[] payload) throws Exception {
        int id;
        GetPlayerTokenReqOuterClass.GetPlayerTokenReq req = GetPlayerTokenReqOuterClass.GetPlayerTokenReq.parseFrom(payload);
        Account account = DatabaseHelper.getAccountById(req.getAccountUid());
        if (account == null) {
            return;
        }
        if (!account.getToken().equals(req.getAccountToken())) {
            return;
        }
        session.setAccount(account);
        session.setUseSecretKey(true);
        session.setState(GameSession.SessionState.WAITING_FOR_LOGIN);
        boolean doesPlayerExist = false;
        if (account.getPlayerUid() > 0) {
            doesPlayerExist = DatabaseHelper.checkPlayerExists(account.getPlayerUid());
        }
        if (!doesPlayerExist && (id = DatabaseHelper.getNextPlayerId(session.getAccount().getPlayerUid())) != session.getAccount().getPlayerUid()) {
            session.getAccount().setPlayerId(id);
            session.getAccount().save();
        }
        session.send(new PacketGetPlayerTokenRsp(session, doesPlayerExist));
    }
}

