/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.packet.recv;

import emu.grasscutter.game.entity.GameEntity;
import emu.grasscutter.net.packet.Opcodes;
import emu.grasscutter.net.packet.PacketHandler;
import emu.grasscutter.net.proto.CombatInvocationsNotifyOuterClass;
import emu.grasscutter.net.proto.CombatInvokeEntryOuterClass;
import emu.grasscutter.net.proto.EntityMoveInfoOuterClass;
import emu.grasscutter.net.proto.EvtBeingHitInfoOuterClass;
import emu.grasscutter.server.game.GameSession;

@Opcodes(value=347)
public class HandlerCombatInvocationsNotify
extends PacketHandler {
    @Override
    public void handle(GameSession session, byte[] header, byte[] payload) throws Exception {
        CombatInvocationsNotifyOuterClass.CombatInvocationsNotify notif = CombatInvocationsNotifyOuterClass.CombatInvocationsNotify.parseFrom(payload);
        for (CombatInvokeEntryOuterClass.CombatInvokeEntry entry : notif.getInvokeListList()) {
            switch (entry.getArgumentType()) {
                case COMBAT_EVT_BEING_HIT: {
                    EvtBeingHitInfoOuterClass.EvtBeingHitInfo hitInfo = EvtBeingHitInfoOuterClass.EvtBeingHitInfo.parseFrom(entry.getCombatData());
                    session.getPlayer().getScene().handleAttack(hitInfo.getAttackResult());
                    break;
                }
                case ENTITY_MOVE: {
                    EntityMoveInfoOuterClass.EntityMoveInfo moveInfo = EntityMoveInfoOuterClass.EntityMoveInfo.parseFrom(entry.getCombatData());
                    GameEntity entity = session.getPlayer().getScene().getEntityById(moveInfo.getEntityId());
                    if (entity == null) break;
                    entity.getPosition().set(moveInfo.getMotionInfo().getPos());
                    entity.getRotation().set(moveInfo.getMotionInfo().getRot());
                    entity.setLastMoveSceneTimeMs(moveInfo.getSceneTime());
                    entity.setLastMoveReliableSeq(moveInfo.getReliableSeq());
                    entity.setMotionState(moveInfo.getMotionInfo().getState());
                    break;
                }
            }
            session.getPlayer().getCombatInvokeHandler().addEntry(entry.getForwardType(), entry);
        }
        if (notif.getInvokeListList().size() > 0) {
            session.getPlayer().getCombatInvokeHandler().update(session.getPlayer());
        }
    }
}

