/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.http.gacha;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.Account;
import emu.grasscutter.utils.FileUtils;
import express.http.HttpContextHandler;
import express.http.Request;
import express.http.Response;
import java.io.File;
import java.io.IOException;

public final class GachaRecordHandler
implements HttpContextHandler {
    String render_template;

    public GachaRecordHandler() {
        File template = new File(Grasscutter.getConfig().DATA_FOLDER + "gacha_records.html");
        this.render_template = template.exists() ? new String(FileUtils.read(template)) : "{{REPLACE_RECORD}}";
    }

    @Override
    public void handle(Request req, Response res) throws IOException {
        Account account;
        String sessionKey = req.query("s");
        int page = 0;
        int gachaType = 0;
        if (req.query("p") != null) {
            page = Integer.valueOf(req.query("p"));
        }
        if (req.query("gachaType") != null) {
            gachaType = Integer.valueOf(req.query("gachaType"));
        }
        if ((account = DatabaseHelper.getAccountBySessionKey(sessionKey)) != null) {
            String records = DatabaseHelper.getGachaRecords(account.getPlayerUid(), page, gachaType).toString();
            String response = this.render_template.replace("{{REPLACE_RECORD}}", records).replace("{{REPLACE_MAXPAGE}}", String.valueOf(DatabaseHelper.getGachaRecordsMaxPage(account.getPlayerUid(), page, gachaType)));
            res.send(response);
        } else {
            res.send("404");
        }
    }
}

