/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.game;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.game.Account;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.net.packet.BasePacket;
import emu.grasscutter.net.packet.PacketOpcodesUtil;
import emu.grasscutter.netty.KcpChannel;
import emu.grasscutter.server.event.game.SendPacketEvent;
import emu.grasscutter.server.game.GameServer;
import emu.grasscutter.utils.Crypto;
import emu.grasscutter.utils.FileUtils;
import emu.grasscutter.utils.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Set;

public class GameSession
extends KcpChannel {
    private GameServer server;
    private Account account;
    private Player player;
    private boolean useSecretKey;
    private SessionState state;
    private int clientTime;
    private long lastPingTime;
    private int lastClientSeq = 10;
    private static final Set<Integer> loopPacket = Set.of(Integer.valueOf(37), Integer.valueOf(93), Integer.valueOf(26), Integer.valueOf(55), Integer.valueOf(2360));

    public GameSession(GameServer server) {
        this.server = server;
        this.state = SessionState.WAITING_FOR_TOKEN;
        this.lastPingTime = System.currentTimeMillis();
    }

    public GameServer getServer() {
        return this.server;
    }

    public InetSocketAddress getAddress() {
        if (this.getChannel() == null) {
            return null;
        }
        return this.getChannel().remoteAddress();
    }

    public boolean useSecretKey() {
        return this.useSecretKey;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public String getAccountId() {
        return this.getAccount().getId();
    }

    public Player getPlayer() {
        return this.player;
    }

    public synchronized void setPlayer(Player player) {
        this.player = player;
        this.player.setSession(this);
        this.player.setAccount(this.getAccount());
    }

    public SessionState getState() {
        return this.state;
    }

    public void setState(SessionState state) {
        this.state = state;
    }

    public boolean isLoggedIn() {
        return this.getPlayer() != null;
    }

    public void setUseSecretKey(boolean useSecretKey) {
        this.useSecretKey = useSecretKey;
    }

    public int getClientTime() {
        return this.clientTime;
    }

    public long getLastPingTime() {
        return this.lastPingTime;
    }

    public void updateLastPingTime(int clientTime) {
        this.clientTime = clientTime;
        this.lastPingTime = System.currentTimeMillis();
    }

    public int getNextClientSequence() {
        return ++this.lastClientSeq;
    }

    @Override
    protected void onConnect() {
        Grasscutter.getLogger().info(String.format(Grasscutter.getLanguage().Client_connect, this.getAddress().getHostString().toLowerCase()));
    }

    @Override
    protected synchronized void onDisconnect() {
        Grasscutter.getLogger().info(String.format(Grasscutter.getLanguage().Client_disconnect, this.getAddress().getHostString().toLowerCase()));
        this.setState(SessionState.INACTIVE);
        if (this.isLoggedIn()) {
            this.getPlayer().onLogout();
            this.getServer().getPlayers().remove(this.getPlayer().getUid());
        }
    }

    protected void logPacket(ByteBuffer buf) {
        ByteBuf b = Unpooled.wrappedBuffer(buf.array());
        this.logPacket(b);
    }

    public void replayPacket(int opcode, String name) {
        String filePath = Grasscutter.getConfig().PACKETS_FOLDER + name;
        File p = new File(filePath);
        if (!p.exists()) {
            return;
        }
        byte[] packet = FileUtils.read(p);
        BasePacket basePacket = new BasePacket(opcode);
        basePacket.setData(packet);
        this.send(basePacket);
    }

    public void send(BasePacket packet) {
        if (packet.getOpcode() <= 0) {
            Grasscutter.getLogger().warn("Tried to send packet with missing cmd id!");
            return;
        }
        if (packet.shouldBuildHeader()) {
            packet.buildHeader(this.getNextClientSequence());
        }
        if (Grasscutter.getConfig().DebugMode == Grasscutter.ServerDebugMode.ALL) {
            this.logPacket(packet);
        }
        SendPacketEvent event = new SendPacketEvent(this, packet);
        event.call();
        if (!event.isCanceled()) {
            this.send(event.getPacket().build());
        }
    }

    private void logPacket(BasePacket packet) {
        if (!loopPacket.contains(packet.getOpcode())) {
            Grasscutter.getLogger().info("SEND: " + PacketOpcodesUtil.getOpcodeName(packet.getOpcode()) + " (" + packet.getOpcode() + ")");
            System.out.println(Utils.bytesToHex(packet.getData()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(ChannelHandlerContext ctx, ByteBuf data) {
        byte[] byteData = Utils.byteBufToArray(data);
        Crypto.xor(byteData, this.useSecretKey() ? Crypto.ENCRYPT_KEY : Crypto.DISPATCH_KEY);
        ByteBuf packet = Unpooled.wrappedBuffer(byteData);
        try {
            while (packet.readableBytes() > 0) {
                if (packet.readableBytes() < 12) {
                    return;
                }
                short const1 = packet.readShort();
                if (const1 != 17767) {
                    return;
                }
                short opcode = packet.readShort();
                short headerLength = packet.readShort();
                int payloadLength = packet.readInt();
                byte[] header = new byte[headerLength];
                byte[] payload = new byte[payloadLength];
                packet.readBytes(header);
                packet.readBytes(payload);
                short const2 = packet.readShort();
                if (const2 != -30293) {
                    return;
                }
                if (Grasscutter.getConfig().DebugMode == Grasscutter.ServerDebugMode.ALL && !loopPacket.contains(opcode)) {
                    Grasscutter.getLogger().info("RECV: " + PacketOpcodesUtil.getOpcodeName(opcode) + " (" + opcode + ")");
                    System.out.println(Utils.bytesToHex(payload));
                }
                this.getServer().getPacketHandler().handle(this, opcode, header, payload);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            packet.release();
        }
    }

    public static enum SessionState {
        INACTIVE,
        WAITING_FOR_TOKEN,
        WAITING_FOR_LOGIN,
        PICKING_CHARACTER,
        ACTIVE;

    }
}

