/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.game;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.net.packet.Opcodes;
import emu.grasscutter.net.packet.PacketHandler;
import emu.grasscutter.net.packet.PacketOpcodesUtil;
import emu.grasscutter.server.event.game.ReceivePacketEvent;
import emu.grasscutter.server.game.GameSession;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class GameServerPacketHandler {
    private final Int2ObjectMap<PacketHandler> handlers = new Int2ObjectOpenHashMap<PacketHandler>();

    public GameServerPacketHandler(Class<? extends PacketHandler> handlerClass) {
        this.registerHandlers(handlerClass);
    }

    public void registerPacketHandler(Class<? extends PacketHandler> handlerClass) {
        try {
            Opcodes opcode = handlerClass.getAnnotation(Opcodes.class);
            if (opcode == null || opcode.disabled() || opcode.value() <= 0) {
                return;
            }
            PacketHandler packetHandler = handlerClass.newInstance();
            this.handlers.put(opcode.value(), packetHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void registerHandlers(Class<? extends PacketHandler> handlerClass) {
        Reflections reflections = new Reflections("emu.grasscutter.server.packet", new Scanner[0]);
        Set<Class<? extends PacketHandler>> handlerClasses = reflections.getSubTypesOf(handlerClass);
        for (Class<? extends PacketHandler> obj : handlerClasses) {
            this.registerPacketHandler(obj);
        }
        Grasscutter.getLogger().info("Registered " + this.handlers.size() + " " + handlerClass.getSimpleName() + "s");
    }

    public void handle(GameSession session, int opcode, byte[] header, byte[] payload) {
        PacketHandler handler = (PacketHandler)this.handlers.get(opcode);
        if (handler != null) {
            try {
                GameSession.SessionState state = session.getState();
                if (opcode != 37 && (opcode == 160 ? state != GameSession.SessionState.WAITING_FOR_TOKEN : (opcode == 110 ? state != GameSession.SessionState.WAITING_FOR_LOGIN : (opcode == 155 ? state != GameSession.SessionState.PICKING_CHARACTER : state != GameSession.SessionState.ACTIVE)))) {
                    return;
                }
                ReceivePacketEvent event = new ReceivePacketEvent(session, opcode, payload);
                event.call();
                if (!event.isCanceled()) {
                    handler.handle(session, header, event.getPacketData());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
        if (Grasscutter.getConfig().DebugMode == Grasscutter.ServerDebugMode.MISSING) {
            Grasscutter.getLogger().info("Unhandled packet (" + opcode + "): " + PacketOpcodesUtil.getOpcodeName(opcode));
        }
    }
}

