/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.dispatch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.protobuf.ByteString;
import emu.grasscutter.Config;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.Account;
import emu.grasscutter.net.proto.QueryCurrRegionHttpRspOuterClass;
import emu.grasscutter.net.proto.QueryRegionListHttpRspOuterClass;
import emu.grasscutter.net.proto.RegionInfoOuterClass;
import emu.grasscutter.net.proto.RegionSimpleInfoOuterClass;
import emu.grasscutter.server.dispatch.AnnouncementHandler;
import emu.grasscutter.server.dispatch.ClientLogHandler;
import emu.grasscutter.server.dispatch.DispatchHttpJsonHandler;
import emu.grasscutter.server.dispatch.authentication.AuthenticationHandler;
import emu.grasscutter.server.dispatch.authentication.DefaultAuthenticationHandler;
import emu.grasscutter.server.dispatch.json.ComboTokenReqJson;
import emu.grasscutter.server.dispatch.json.ComboTokenResJson;
import emu.grasscutter.server.dispatch.json.LoginAccountRequestJson;
import emu.grasscutter.server.dispatch.json.LoginResultJson;
import emu.grasscutter.server.dispatch.json.LoginTokenRequestJson;
import emu.grasscutter.server.event.dispatch.QueryAllRegionsEvent;
import emu.grasscutter.server.event.dispatch.QueryCurrentRegionEvent;
import emu.grasscutter.server.http.gacha.GachaRecordHandler;
import emu.grasscutter.server.http.gcstatic.StaticFileHandler;
import emu.grasscutter.utils.FileUtils;
import express.Express;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public final class DispatchServer {
    public static String query_region_list = "";
    public static String query_cur_region = "";
    private final Gson gson;
    private final String defaultServerName = "os_usa";
    public String regionListBase64;
    public Map<String, RegionData> regions = new HashMap<String, RegionData>();
    private AuthenticationHandler authHandler;
    private Express httpServer;

    public DispatchServer() {
        this.gson = new GsonBuilder().create();
        this.loadQueries();
        this.initRegion();
    }

    public Express getServer() {
        return this.httpServer;
    }

    public void setHttpServer(Express httpServer) {
        this.httpServer.stop();
        this.httpServer = httpServer;
        this.httpServer.listen(Grasscutter.getConfig().getDispatchOptions().Port);
    }

    public Gson getGsonFactory() {
        return this.gson;
    }

    public QueryCurrRegionHttpRspOuterClass.QueryCurrRegionHttpRsp getCurrRegion() {
        if (Grasscutter.getConfig().RunMode == Grasscutter.ServerRunMode.HYBRID) {
            return this.regions.get((Object)"os_usa").parsedRegionQuery;
        }
        Grasscutter.getLogger().warn("[Dispatch] Unsupported run mode for getCurrRegion()");
        return null;
    }

    public void loadQueries() {
        File file = new File(Grasscutter.getConfig().DATA_FOLDER + "query_region_list.txt");
        if (file.exists()) {
            query_region_list = new String(FileUtils.read(file));
        } else {
            Grasscutter.getLogger().warn("[Dispatch] query_region_list not found! Using default region list.");
        }
        file = new File(Grasscutter.getConfig().DATA_FOLDER + "query_cur_region.txt");
        if (file.exists()) {
            query_cur_region = new String(FileUtils.read(file));
        } else {
            Grasscutter.getLogger().warn("[Dispatch] query_cur_region not found! Using default current region.");
        }
    }

    private void initRegion() {
        try {
            byte[] decoded = Base64.getDecoder().decode(query_region_list);
            QueryRegionListHttpRspOuterClass.QueryRegionListHttpRsp rl = QueryRegionListHttpRspOuterClass.QueryRegionListHttpRsp.parseFrom(decoded);
            byte[] decoded2 = Base64.getDecoder().decode(query_cur_region);
            QueryCurrRegionHttpRspOuterClass.QueryCurrRegionHttpRsp regionQuery = QueryCurrRegionHttpRspOuterClass.QueryCurrRegionHttpRsp.parseFrom(decoded2);
            ArrayList<RegionSimpleInfoOuterClass.RegionSimpleInfo> servers = new ArrayList<RegionSimpleInfoOuterClass.RegionSimpleInfo>();
            ArrayList<String> usedNames = new ArrayList<String>();
            if (Grasscutter.getConfig().RunMode == Grasscutter.ServerRunMode.HYBRID) {
                RegionSimpleInfoOuterClass.RegionSimpleInfo regionSimpleInfo = RegionSimpleInfoOuterClass.RegionSimpleInfo.newBuilder().setName("os_usa").setTitle(Grasscutter.getConfig().getGameServerOptions().Name).setType("DEV_PUBLIC").setDispatchUrl("http" + (Grasscutter.getConfig().getDispatchOptions().FrontHTTPS != false ? "s" : "") + "://" + (Grasscutter.getConfig().getDispatchOptions().PublicIp.isEmpty() ? Grasscutter.getConfig().getDispatchOptions().Ip : Grasscutter.getConfig().getDispatchOptions().PublicIp) + ":" + (Grasscutter.getConfig().getDispatchOptions().PublicPort != 0 ? Grasscutter.getConfig().getDispatchOptions().PublicPort : Grasscutter.getConfig().getDispatchOptions().Port) + "/query_cur_region/os_usa").build();
                usedNames.add("os_usa");
                servers.add(regionSimpleInfo);
                RegionInfoOuterClass.RegionInfo serverRegion = regionQuery.getRegionInfo().toBuilder().setGateserverIp(Grasscutter.getConfig().getGameServerOptions().PublicIp.isEmpty() ? Grasscutter.getConfig().getGameServerOptions().Ip : Grasscutter.getConfig().getGameServerOptions().PublicIp).setGateserverPort(Grasscutter.getConfig().getGameServerOptions().PublicPort != 0 ? Grasscutter.getConfig().getGameServerOptions().PublicPort : Grasscutter.getConfig().getGameServerOptions().Port).setSecretKey(ByteString.copyFrom(FileUtils.read(Grasscutter.getConfig().KEY_FOLDER + "dispatchSeed.bin"))).build();
                QueryCurrRegionHttpRspOuterClass.QueryCurrRegionHttpRsp parsedRegionQuery = regionQuery.toBuilder().setRegionInfo(serverRegion).build();
                this.regions.put("os_usa", new RegionData(parsedRegionQuery, Base64.getEncoder().encodeToString(parsedRegionQuery.toByteString().toByteArray())));
            } else if (Grasscutter.getConfig().getDispatchOptions().getGameServers().length == 0) {
                Grasscutter.getLogger().error("[Dispatch] There are no game servers available. Exiting due to unplayable state.");
                System.exit(1);
            }
            for (Config.DispatchServerOptions.RegionInfo regionInfo : Grasscutter.getConfig().getDispatchOptions().getGameServers()) {
                if (usedNames.contains(regionInfo.Name)) {
                    Grasscutter.getLogger().error("Region name already in use.");
                    continue;
                }
                RegionSimpleInfoOuterClass.RegionSimpleInfo server = RegionSimpleInfoOuterClass.RegionSimpleInfo.newBuilder().setName(regionInfo.Name).setTitle(regionInfo.Title).setType("DEV_PUBLIC").setDispatchUrl("http" + (Grasscutter.getConfig().getDispatchOptions().FrontHTTPS != false ? "s" : "") + "://" + (Grasscutter.getConfig().getDispatchOptions().PublicIp.isEmpty() ? Grasscutter.getConfig().getDispatchOptions().Ip : Grasscutter.getConfig().getDispatchOptions().PublicIp) + ":" + (Grasscutter.getConfig().getDispatchOptions().PublicPort != 0 ? Grasscutter.getConfig().getDispatchOptions().PublicPort : Grasscutter.getConfig().getDispatchOptions().Port) + "/query_cur_region/" + regionInfo.Name).build();
                usedNames.add(regionInfo.Name);
                servers.add(server);
                RegionInfoOuterClass.RegionInfo serverRegion = regionQuery.getRegionInfo().toBuilder().setGateserverIp(regionInfo.Ip).setGateserverPort(regionInfo.Port).setSecretKey(ByteString.copyFrom(FileUtils.read(Grasscutter.getConfig().KEY_FOLDER + "dispatchSeed.bin"))).build();
                QueryCurrRegionHttpRspOuterClass.QueryCurrRegionHttpRsp parsedRegionQuery = regionQuery.toBuilder().setRegionInfo(serverRegion).build();
                this.regions.put(regionInfo.Name, new RegionData(parsedRegionQuery, Base64.getEncoder().encodeToString(parsedRegionQuery.toByteString().toByteArray())));
            }
            QueryRegionListHttpRspOuterClass.QueryRegionListHttpRsp queryRegionListHttpRsp = QueryRegionListHttpRspOuterClass.QueryRegionListHttpRsp.newBuilder().addAllRegionList(servers).setClientSecretKey(rl.getClientSecretKey()).setClientCustomConfigEncrypted(rl.getClientCustomConfigEncrypted()).setEnableLoginPc(true).build();
            this.regionListBase64 = Base64.getEncoder().encodeToString(queryRegionListHttpRsp.toByteString().toByteArray());
        }
        catch (Exception e) {
            Grasscutter.getLogger().error("[Dispatch] Error while initializing region info!", e);
        }
    }

    public void start() throws Exception {
        this.httpServer = new Express(config -> {
            config.server(() -> {
                ServerConnector serverConnector;
                Server server = new Server();
                if (Grasscutter.getConfig().getDispatchOptions().UseSSL.booleanValue()) {
                    SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
                    File keystoreFile = new File(Grasscutter.getConfig().getDispatchOptions().KeystorePath);
                    if (keystoreFile.exists()) {
                        try {
                            sslContextFactory.setKeyStorePath(keystoreFile.getPath());
                            sslContextFactory.setKeyStorePassword(Grasscutter.getConfig().getDispatchOptions().KeystorePassword);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Grasscutter.getLogger().warn(Grasscutter.getLanguage().Not_load_keystore);
                            try {
                                sslContextFactory.setKeyStorePath(keystoreFile.getPath());
                                sslContextFactory.setKeyStorePassword("123456");
                                Grasscutter.getLogger().warn(Grasscutter.getLanguage().Use_default_keystore);
                            }
                            catch (Exception e2) {
                                Grasscutter.getLogger().warn(Grasscutter.getLanguage().Load_keystore_error);
                                e2.printStackTrace();
                            }
                        }
                        serverConnector = new ServerConnector(server, sslContextFactory);
                    } else {
                        Grasscutter.getLogger().warn(Grasscutter.getLanguage().Not_find_ssl_cert);
                        Grasscutter.getConfig().getDispatchOptions().UseSSL = false;
                        serverConnector = new ServerConnector(server);
                    }
                } else {
                    serverConnector = new ServerConnector(server);
                }
                serverConnector.setPort(Grasscutter.getConfig().getDispatchOptions().Port);
                server.setConnectors(new Connector[]{serverConnector});
                return server;
            });
            config.enforceSsl = Grasscutter.getConfig().getDispatchOptions().UseSSL;
            if (Grasscutter.getConfig().DebugMode == Grasscutter.ServerDebugMode.ALL) {
                config.enableDevLogging();
            }
        });
        this.httpServer.get("/", (req, res) -> res.send(Grasscutter.getLanguage().Welcome));
        this.httpServer.raw().error(404, ctx -> {
            if (Grasscutter.getConfig().DebugMode == Grasscutter.ServerDebugMode.MISSING) {
                Grasscutter.getLogger().info(String.format(Grasscutter.getLanguage().Potential_unhandled_request, ctx.method(), ctx.url()));
            }
            ctx.contentType("text/html");
            ctx.result("<!doctype html><html lang=\"en\"><body><img src=\"https://http.cat/404\" /></body></html>");
        });
        this.httpServer.get("/authentication/type", (req, res) -> res.send(this.getAuthHandler().getClass().getName()));
        this.httpServer.post("/authentication/login", (req, res) -> this.getAuthHandler().handleLogin(req, res));
        this.httpServer.post("/authentication/register", (req, res) -> this.getAuthHandler().handleRegister(req, res));
        this.httpServer.post("/authentication/change_password", (req, res) -> this.getAuthHandler().handleChangePassword(req, res));
        this.httpServer.get("/query_region_list", (req, res) -> {
            Grasscutter.getLogger().info(String.format("[Dispatch] Client %s request: query_region_list", req.ip()));
            QueryAllRegionsEvent event = new QueryAllRegionsEvent(this.regionListBase64);
            event.call();
            res.send(event.getRegionList());
        });
        this.httpServer.get("/query_cur_region/:id", (req, res) -> {
            String regionName = req.params("id");
            Grasscutter.getLogger().info(String.format("Client %s request: query_cur_region/%s", req.ip(), regionName));
            String response = "CAESGE5vdCBGb3VuZCB2ZXJzaW9uIGNvbmZpZw==";
            if (req.query().values().size() > 0) {
                response = this.regions.get((Object)regionName).Base64;
            }
            QueryCurrentRegionEvent event = new QueryCurrentRegionEvent(response);
            event.call();
            res.send(event.getRegionInfo());
        });
        this.httpServer.post("/hk4e_global/mdk/shield/api/login", (req, res) -> {
            LoginAccountRequestJson requestData = null;
            try {
                String body2 = req.ctx().body();
                requestData = this.getGsonFactory().fromJson(body2, LoginAccountRequestJson.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (requestData == null) {
                return;
            }
            Grasscutter.getLogger().info(String.format("[Dispatch] Client %s is trying to log in", req.ip()));
            res.send(this.getAuthHandler().handleGameLogin(req, requestData));
        });
        this.httpServer.post("/hk4e_global/mdk/shield/api/verify", (req, res) -> {
            LoginTokenRequestJson requestData = null;
            try {
                String body2 = req.ctx().body();
                requestData = this.getGsonFactory().fromJson(body2, LoginTokenRequestJson.class);
            }
            catch (Exception body2) {
                // empty catch block
            }
            if (requestData == null) {
                return;
            }
            LoginResultJson responseData = new LoginResultJson();
            Grasscutter.getLogger().info(String.format(Grasscutter.getLanguage().Client_login_token, req.ip()));
            Account account = DatabaseHelper.getAccountById(requestData.uid);
            if (account == null || !account.getSessionKey().equals(requestData.token)) {
                responseData.retcode = -111;
                responseData.message = Grasscutter.getLanguage().Game_account_cache_error;
                Grasscutter.getLogger().info(String.format(Grasscutter.getLanguage().Client_token_login_failed, req.ip()));
            } else {
                responseData.message = "OK";
                responseData.data.account.uid = requestData.uid;
                responseData.data.account.token = requestData.token;
                responseData.data.account.email = account.getEmail();
                Grasscutter.getLogger().info(String.format(Grasscutter.getLanguage().Client_login_in_token, req.ip(), responseData.data.account.uid));
            }
            res.send(responseData);
        });
        this.httpServer.post("/hk4e_global/combo/granter/login/v2/login", (req, res) -> {
            ComboTokenReqJson requestData = null;
            try {
                String body2 = req.ctx().body();
                requestData = this.getGsonFactory().fromJson(body2, ComboTokenReqJson.class);
            }
            catch (Exception body2) {
                // empty catch block
            }
            if (requestData == null || requestData.data == null) {
                return;
            }
            ComboTokenReqJson.LoginTokenData loginData = this.getGsonFactory().fromJson(requestData.data, ComboTokenReqJson.LoginTokenData.class);
            ComboTokenResJson responseData = new ComboTokenResJson();
            Account account = DatabaseHelper.getAccountById(loginData.uid);
            if (account == null || !account.getSessionKey().equals(loginData.token)) {
                responseData.retcode = -201;
                responseData.message = Grasscutter.getLanguage().Wrong_session_key;
                Grasscutter.getLogger().info(String.format(Grasscutter.getLanguage().Client_failed_exchange_combo_token, req.ip()));
            } else {
                responseData.message = "OK";
                responseData.data.open_id = loginData.uid;
                responseData.data.combo_id = "157795300";
                responseData.data.combo_token = account.generateLoginToken();
                Grasscutter.getLogger().info(String.format(Grasscutter.getLanguage().Client_exchange_combo_token, req.ip()));
            }
            res.send(responseData);
        });
        this.httpServer.get("/hk4e_global/mdk/agreement/api/getAgreementInfos", new DispatchHttpJsonHandler("{\"retcode\":0,\"message\":\"OK\",\"data\":{\"marketing_agreements\":[]}}"));
        this.httpServer.all("/hk4e_global/combo/granter/api/compareProtocolVersion", new DispatchHttpJsonHandler("{\"retcode\":0,\"message\":\"OK\",\"data\":{\"modified\":true,\"protocol\":{\"id\":0,\"app_id\":4,\"language\":\"en\",\"user_proto\":\"\",\"priv_proto\":\"\",\"major\":7,\"minimum\":0,\"create_time\":\"0\",\"teenager_proto\":\"\",\"third_proto\":\"\"}}}"));
        this.httpServer.all("/common/hk4e_global/announcement/api/getAlertPic", new DispatchHttpJsonHandler("{\"retcode\":0,\"message\":\"OK\",\"data\":{\"total\":0,\"list\":[]}}"));
        this.httpServer.all("/common/hk4e_global/announcement/api/getAlertAnn", new DispatchHttpJsonHandler("{\"retcode\":0,\"message\":\"OK\",\"data\":{\"alert\":false,\"alert_id\":0,\"remind\":true}}"));
        this.httpServer.all("/common/hk4e_global/announcement/api/getAnnList", new AnnouncementHandler());
        this.httpServer.all("/common/hk4e_global/announcement/api/getAnnContent", new AnnouncementHandler());
        this.httpServer.all("/hk4e_global/mdk/shopwindow/shopwindow/listPriceTier", new DispatchHttpJsonHandler("{\"retcode\":0,\"message\":\"OK\",\"data\":{\"suggest_currency\":\"USD\",\"tiers\":[]}}"));
        this.httpServer.post("/account/risky/api/check", new DispatchHttpJsonHandler("{\"retcode\":0,\"message\":\"OK\",\"data\":{\"id\":\"none\",\"action\":\"ACTION_NONE\",\"geetest\":null}}"));
        this.httpServer.get("/combo/box/api/config/sdk/combo", new DispatchHttpJsonHandler("{\"retcode\":0,\"message\":\"OK\",\"data\":{\"vals\":{\"disable_email_bind_skip\":\"false\",\"email_bind_remind_interval\":\"7\",\"email_bind_remind\":\"true\"}}}"));
        this.httpServer.get("/hk4e_global/combo/granter/api/getConfig", new DispatchHttpJsonHandler("{\"retcode\":0,\"message\":\"OK\",\"data\":{\"protocol\":true,\"qr_enabled\":false,\"log_level\":\"INFO\",\"announce_url\":\"https://webstatic-sea.hoyoverse.com/hk4e/announcement/index.html?sdk_presentation_style=fullscreen\\u0026sdk_screen_transparent=true\\u0026game_biz=hk4e_global\\u0026auth_appid=announcement\\u0026game=hk4e#/\",\"push_alias_type\":2,\"disable_ysdk_guard\":false,\"enable_announce_pic_popup\":true}}"));
        this.httpServer.get("/hk4e_global/mdk/shield/api/loadConfig", new DispatchHttpJsonHandler("{\"retcode\":0,\"message\":\"OK\",\"data\":{\"id\":6,\"game_key\":\"hk4e_global\",\"client\":\"PC\",\"identity\":\"I_IDENTITY\",\"guest\":false,\"ignore_versions\":\"\",\"scene\":\"S_NORMAL\",\"name\":\"\u539f\u795e\u6d77\u5916\",\"disable_regist\":false,\"enable_email_captcha\":false,\"thirdparty\":[\"fb\",\"tw\"],\"disable_mmt\":false,\"server_guest\":false,\"thirdparty_ignore\":{\"tw\":\"\",\"fb\":\"\"},\"enable_ps_bind_account\":false,\"thirdparty_login_configs\":{\"tw\":{\"token_type\":\"TK_GAME_TOKEN\",\"game_token_expires_in\":604800},\"fb\":{\"token_type\":\"TK_GAME_TOKEN\",\"game_token_expires_in\":604800}}}}"));
        this.httpServer.post("/data_abtest_api/config/experiment/list", new DispatchHttpJsonHandler("{\"retcode\":0,\"success\":true,\"message\":\"\",\"data\":[{\"code\":1000,\"type\":2,\"config_id\":\"14\",\"period_id\":\"6036_99\",\"version\":\"1\",\"configs\":{\"cardType\":\"old\"}}]}"));
        this.httpServer.all("/log/sdk/upload", new DispatchHttpJsonHandler("{\"code\":0}"));
        this.httpServer.all("/sdk/upload", new DispatchHttpJsonHandler("{\"code\":0}"));
        this.httpServer.post("/sdk/dataUpload", new DispatchHttpJsonHandler("{\"code\":0}"));
        this.httpServer.all("/perf/config/verify", new DispatchHttpJsonHandler("{\"code\":0}"));
        this.httpServer.all("/log", new ClientLogHandler());
        this.httpServer.all("/crash/dataUpload", new ClientLogHandler());
        this.httpServer.get("/admin/mi18n/plat_oversea/m202003048/m202003048-version.json", new DispatchHttpJsonHandler("{\"version\":51}"));
        this.httpServer.get("/gacha", new GachaRecordHandler());
        this.httpServer.get("/gcstatic/*", new StaticFileHandler());
        this.httpServer.listen(Grasscutter.getConfig().getDispatchOptions().Port);
        Grasscutter.getLogger().info(String.format(Grasscutter.getLanguage().Dispatch_start_server_port, this.httpServer.raw().port()));
    }

    private Map<String, String> parseQueryString(String qs) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (qs == null) {
            return result;
        }
        int last = 0;
        int l = qs.length();
        while (last < l) {
            int next2 = qs.indexOf(38, last);
            if (next2 == -1) {
                next2 = l;
            }
            if (next2 > last) {
                int eqPos = qs.indexOf(61, last);
                try {
                    if (eqPos < 0 || eqPos > next2) {
                        result.put(URLDecoder.decode(qs.substring(last, next2), "utf-8"), "");
                    } else {
                        result.put(URLDecoder.decode(qs.substring(last, eqPos), "utf-8"), URLDecoder.decode(qs.substring(eqPos + 1, next2), "utf-8"));
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            last = next2 + 1;
        }
        return result;
    }

    public AuthenticationHandler getAuthHandler() {
        if (this.authHandler == null) {
            return new DefaultAuthenticationHandler();
        }
        return this.authHandler;
    }

    public boolean registerAuthHandler(AuthenticationHandler authHandler) {
        if (this.authHandler != null) {
            Grasscutter.getLogger().error(String.format("[Dispatch] Unable to register '%s' authentication handler. \nThe '%s' authentication handler has already been registered", authHandler.getClass().getName(), this.authHandler.getClass().getName()));
            return false;
        }
        this.authHandler = authHandler;
        return true;
    }

    public void resetAuthHandler() {
        this.authHandler = null;
    }

    public static class RegionData {
        QueryCurrRegionHttpRspOuterClass.QueryCurrRegionHttpRsp parsedRegionQuery;
        String Base64;

        public RegionData(QueryCurrRegionHttpRspOuterClass.QueryCurrRegionHttpRsp prq, String b64) {
            this.parsedRegionQuery = prq;
            this.Base64 = b64;
        }

        public QueryCurrRegionHttpRspOuterClass.QueryCurrRegionHttpRsp getParsedRegionQuery() {
            return this.parsedRegionQuery;
        }

        public String getBase64() {
            return this.Base64;
        }
    }
}

