/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.scripts.serializer;

import emu.grasscutter.scripts.serializer.Serializer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

public class LuaSerializer
implements Serializer {
    @Override
    public <T> List<T> toList(Class<T> type2, Object obj) {
        return this.serializeList(type2, (LuaTable)obj);
    }

    @Override
    public <T> T toObject(Class<T> type2, Object obj) {
        return this.serialize(type2, (LuaTable)obj);
    }

    public <T> List<T> serializeList(Class<T> type2, LuaTable table) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        try {
            LuaValue[] keys2;
            for (LuaValue k : keys2 = table.keys()) {
                try {
                    LuaValue keyValue = table.get(k);
                    Object object = null;
                    object = keyValue.istable() ? (Object)this.serialize(type2, keyValue.checktable()) : (keyValue.isint() ? Integer.valueOf(keyValue.toint()) : (keyValue.isnumber() ? Float.valueOf(keyValue.tofloat()) : (keyValue.isstring() ? keyValue.tojstring() : keyValue)));
                    if (object == null) continue;
                    list.add((Integer)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public <T> T serialize(Class<T> type2, LuaTable table) {
        Object object = null;
        if (type2 == List.class) {
            try {
                Class<?> listType = type2.getTypeParameters()[0].getClass();
                return (T)this.serializeList(listType, table);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            LuaValue[] keys2;
            object = type2.getDeclaredConstructor(new Class[0]).newInstance(null);
            for (LuaValue k : keys2 = table.keys()) {
                try {
                    Field field = object.getClass().getDeclaredField(k.checkjstring());
                    if (field == null) continue;
                    field.setAccessible(true);
                    LuaValue keyValue = table.get(k);
                    if (keyValue.istable()) {
                        field.set(object, this.serialize(field.getType(), keyValue.checktable()));
                        continue;
                    }
                    if (field.getType().equals(Float.TYPE)) {
                        field.setFloat(object, keyValue.tofloat());
                        continue;
                    }
                    if (field.getType().equals(Integer.TYPE)) {
                        field.setInt(object, keyValue.toint());
                        continue;
                    }
                    if (field.getType().equals(String.class)) {
                        field.set(object, keyValue.tojstring());
                        continue;
                    }
                    field.set(object, keyValue);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)object;
    }
}

