/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.scripts;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.game.props.EntityType;
import emu.grasscutter.scripts.constants.EventType;
import emu.grasscutter.scripts.constants.ScriptGadgetState;
import emu.grasscutter.scripts.constants.ScriptRegionShape;
import emu.grasscutter.scripts.serializer.LuaSerializer;
import emu.grasscutter.scripts.serializer.Serializer;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.script.LuajContext;

public class ScriptLoader {
    private static ScriptEngineManager sm;
    private static ScriptEngine engine;
    private static ScriptEngineFactory factory;
    private static String fileType;
    private static Serializer serializer;
    private static Map<String, CompiledScript> scripts;

    public static synchronized void init() throws Exception {
        if (sm != null) {
            throw new Exception("Script loader already initialized");
        }
        sm = new ScriptEngineManager();
        engine = sm.getEngineByName("luaj");
        factory = ScriptLoader.getEngine().getFactory();
        fileType = "lua";
        serializer = new LuaSerializer();
        LuajContext ctx = (LuajContext)engine.getContext();
        ctx.globals.set("require", (LuaValue)new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue arg0) {
                return LuaValue.ZERO;
            }
        });
        LuaTable table = new LuaTable();
        Arrays.stream(EntityType.values()).forEach(e -> table.set(e.name().toUpperCase(), e.getValue()));
        ctx.globals.set("EntityType", (LuaValue)table);
        ctx.globals.set("EventType", CoerceJavaToLua.coerce(new EventType()));
        ctx.globals.set("GadgetState", CoerceJavaToLua.coerce(new ScriptGadgetState()));
        ctx.globals.set("RegionShape", CoerceJavaToLua.coerce(new ScriptRegionShape()));
    }

    public static ScriptEngine getEngine() {
        return engine;
    }

    public static String getScriptType() {
        return fileType;
    }

    public static Serializer getSerializer() {
        return serializer;
    }

    public static CompiledScript getScriptByPath(String path) {
        CompiledScript sc = scripts.get(path);
        Grasscutter.getLogger().info("Loaded " + path);
        if (sc == null) {
            File file = new File(path);
            if (!file.exists()) {
                return null;
            }
            try (FileReader fr = new FileReader(file);){
                sc = ((Compilable)((Object)ScriptLoader.getEngine())).compile(fr);
                scripts.put(path, sc);
            }
            catch (Exception e) {
                return null;
            }
        }
        return sc;
    }

    static {
        scripts = new HashMap<String, CompiledScript>();
    }
}

