/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.scripts;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.MonsterData;
import emu.grasscutter.data.def.WorldLevelData;
import emu.grasscutter.game.entity.EntityGadget;
import emu.grasscutter.game.entity.EntityMonster;
import emu.grasscutter.game.entity.GameEntity;
import emu.grasscutter.game.world.Scene;
import emu.grasscutter.scripts.ScriptLib;
import emu.grasscutter.scripts.ScriptLoader;
import emu.grasscutter.scripts.data.SceneBlock;
import emu.grasscutter.scripts.data.SceneConfig;
import emu.grasscutter.scripts.data.SceneGadget;
import emu.grasscutter.scripts.data.SceneGroup;
import emu.grasscutter.scripts.data.SceneInitConfig;
import emu.grasscutter.scripts.data.SceneMonster;
import emu.grasscutter.scripts.data.SceneRegion;
import emu.grasscutter.scripts.data.SceneSuite;
import emu.grasscutter.scripts.data.SceneTrigger;
import emu.grasscutter.scripts.data.SceneVar;
import emu.grasscutter.scripts.data.ScriptArgs;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;

public class SceneScriptManager {
    private final Scene scene;
    private final ScriptLib scriptLib;
    private final LuaValue scriptLibLua;
    private final Map<String, Integer> variables;
    private Bindings bindings;
    private SceneConfig config;
    private List<SceneBlock> blocks;
    private boolean isInit;
    private final Int2ObjectOpenHashMap<Set<SceneTrigger>> triggers;
    private final Int2ObjectOpenHashMap<SceneRegion> regions;

    public SceneScriptManager(Scene scene) {
        this.scene = scene;
        this.scriptLib = new ScriptLib(this);
        this.scriptLibLua = CoerceJavaToLua.coerce(this.scriptLib);
        this.triggers = new Int2ObjectOpenHashMap();
        this.regions = new Int2ObjectOpenHashMap();
        this.variables = new HashMap<String, Integer>();
        if (this.getScene().getId() < 10) {
            return;
        }
        this.init();
    }

    public Scene getScene() {
        return this.scene;
    }

    public ScriptLib getScriptLib() {
        return this.scriptLib;
    }

    public LuaValue getScriptLibLua() {
        return this.scriptLibLua;
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public SceneConfig getConfig() {
        return this.config;
    }

    public List<SceneBlock> getBlocks() {
        return this.blocks;
    }

    public Map<String, Integer> getVariables() {
        return this.variables;
    }

    public Set<SceneTrigger> getTriggersByEvent(int eventId) {
        return this.triggers.computeIfAbsent(eventId, e -> new HashSet());
    }

    public void registerTrigger(SceneTrigger trigger) {
        this.getTriggersByEvent(trigger.event).add(trigger);
    }

    public void deregisterTrigger(SceneTrigger trigger) {
        this.getTriggersByEvent(trigger.event).remove(trigger);
    }

    public SceneRegion getRegionById(int id) {
        return this.regions.get(id);
    }

    public void registerRegion(SceneRegion region) {
        this.regions.put(region.config_id, region);
    }

    public void deregisterRegion(SceneRegion region) {
        this.regions.remove(region.config_id);
    }

    public SceneGroup getGroupById(int groupId) {
        for (SceneBlock block : this.getScene().getLoadedBlocks()) {
            for (SceneGroup group : block.groups) {
                if (group.id != groupId) continue;
                return group;
            }
        }
        return null;
    }

    private void init() {
        CompiledScript cs = ScriptLoader.getScriptByPath(Grasscutter.getConfig().SCRIPTS_FOLDER + "Scene/" + this.getScene().getId() + "/scene" + this.getScene().getId() + "." + ScriptLoader.getScriptType());
        if (cs == null) {
            Grasscutter.getLogger().warn("No script found for scene " + this.getScene().getId());
            return;
        }
        this.bindings = ScriptLoader.getEngine().createBindings();
        this.bindings.put("ScriptLib", (Object)this.getScriptLib());
        try {
            cs.eval(this.getBindings());
            this.config = ScriptLoader.getSerializer().toObject(SceneConfig.class, this.bindings.get("scene_config"));
            List<Integer> blockIds = ScriptLoader.getSerializer().toList(Integer.class, this.bindings.get("blocks"));
            List<SceneBlock> blocks = ScriptLoader.getSerializer().toList(SceneBlock.class, this.bindings.get("block_rects"));
            for (int i2 = 0; i2 < blocks.size(); ++i2) {
                SceneBlock block = blocks.get(0);
                block.id = blockIds.get(i2);
                this.loadBlockFromScript(block);
            }
            this.blocks = blocks;
        }
        catch (ScriptException e) {
            Grasscutter.getLogger().error("Error running script", e);
            return;
        }
        this.isInit = true;
    }

    public boolean isInit() {
        return this.isInit;
    }

    private void loadBlockFromScript(SceneBlock block) {
        CompiledScript cs = ScriptLoader.getScriptByPath(Grasscutter.getConfig().SCRIPTS_FOLDER + "Scene/" + this.getScene().getId() + "/scene" + this.getScene().getId() + "_block" + block.id + "." + ScriptLoader.getScriptType());
        if (cs == null) {
            return;
        }
        try {
            cs.eval(this.getBindings());
            block.groups = ScriptLoader.getSerializer().toList(SceneGroup.class, this.bindings.get("groups"));
            block.groups.forEach(g2 -> {
                g2.block_id = block.id;
            });
        }
        catch (ScriptException e) {
            Grasscutter.getLogger().error("Error loading block " + block.id + " in scene " + this.getScene().getId(), e);
        }
    }

    public void loadGroupFromScript(SceneGroup group) {
        group.setLoaded(true);
        CompiledScript cs = ScriptLoader.getScriptByPath(Grasscutter.getConfig().SCRIPTS_FOLDER + "Scene/" + this.getScene().getId() + "/scene" + this.getScene().getId() + "_group" + group.id + "." + ScriptLoader.getScriptType());
        if (cs == null) {
            return;
        }
        try {
            cs.eval(this.getBindings());
            group.monsters = ScriptLoader.getSerializer().toList(SceneMonster.class, this.bindings.get("monsters"));
            group.gadgets = ScriptLoader.getSerializer().toList(SceneGadget.class, this.bindings.get("gadgets"));
            group.triggers = ScriptLoader.getSerializer().toList(SceneTrigger.class, this.bindings.get("triggers"));
            group.suites = ScriptLoader.getSerializer().toList(SceneSuite.class, this.bindings.get("suites"));
            group.regions = ScriptLoader.getSerializer().toList(SceneRegion.class, this.bindings.get("regions"));
            group.init_config = ScriptLoader.getSerializer().toObject(SceneInitConfig.class, this.bindings.get("init_config"));
            List<SceneVar> variables = ScriptLoader.getSerializer().toList(SceneVar.class, this.bindings.get("variables"));
            variables.forEach(var -> this.getVariables().put(var.name, var.value));
            HashMap map = (HashMap)group.monsters.stream().collect(Collectors.toMap(m3 -> m3.config_id, m3 -> m3));
            for (SceneSuite suite : group.suites) {
                suite.sceneMonsters = new ArrayList<SceneMonster>(suite.monsters.size());
                for (int id : suite.monsters) {
                    SceneMonster monster = (SceneMonster)map.get(id);
                    if (monster == null) continue;
                    suite.sceneMonsters.add(monster);
                }
            }
        }
        catch (ScriptException e) {
            Grasscutter.getLogger().error("Error loading group " + group.id + " in scene " + this.getScene().getId(), e);
        }
    }

    public void onTick() {
        this.checkRegions();
    }

    public void checkRegions() {
        if (this.regions.size() == 0) {
            return;
        }
        for (SceneRegion region : this.regions.values()) {
            this.getScene().getEntities().values().stream().filter(e -> e.getEntityType() <= 2 && region.contains(e.getPosition())).forEach(region::addEntity);
            if (!region.hasNewEntities()) continue;
            this.callEvent(4, new ScriptArgs(region.config_id).setSourceEntityId(region.config_id));
            region.resetNewEntities();
        }
    }

    public void spawnGadgetsInGroup(SceneGroup group) {
        for (SceneGadget g2 : group.gadgets) {
            EntityGadget entity = new EntityGadget(this.getScene(), g2.gadget_id, g2.pos);
            if (entity.getGadgetData() == null) continue;
            entity.setBlockId(group.block_id);
            entity.setConfigId(g2.config_id);
            entity.setGroupId(group.id);
            entity.getRotation().set(g2.rot);
            entity.setState(g2.state);
            this.getScene().addEntity(entity);
            this.callEvent(6, new ScriptArgs(entity.getConfigId()));
        }
    }

    public void spawnMonstersInGroup(SceneGroup group, int suiteIndex) {
        this.spawnMonstersInGroup(group, group.getSuiteByIndex(suiteIndex));
    }

    public void spawnMonstersInGroup(SceneGroup group) {
        this.spawnMonstersInGroup(group, null);
    }

    public void spawnMonstersInGroup(SceneGroup group, SceneSuite suite) {
        List<SceneMonster> monsters = group.monsters;
        if (suite != null) {
            monsters = suite.sceneMonsters;
        }
        ArrayList<GameEntity> toAdd = new ArrayList<GameEntity>();
        for (SceneMonster monster : monsters) {
            WorldLevelData worldLevelData;
            MonsterData data = (MonsterData)GameData.getMonsterDataMap().get(monster.monster_id);
            if (data == null) continue;
            int level = monster.level;
            if (this.getScene().getDungeonData() != null) {
                level = this.getScene().getDungeonData().getShowLevel();
            } else if (this.getScene().getWorld().getWorldLevel() > 0 && (worldLevelData = (WorldLevelData)GameData.getWorldLevelDataMap().get(this.getScene().getWorld().getWorldLevel())) != null) {
                level = worldLevelData.getMonsterLevel();
            }
            EntityMonster entity = new EntityMonster(this.getScene(), data, monster.pos, level);
            entity.getRotation().set(monster.rot);
            entity.setGroupId(group.id);
            entity.setConfigId(monster.config_id);
            toAdd.add(entity);
        }
        if (toAdd.size() > 0) {
            this.getScene().addEntities(toAdd);
            for (GameEntity entity : toAdd) {
                this.callEvent(11, new ScriptArgs(entity.getConfigId()));
            }
        }
    }

    public void callEvent(int eventType, ScriptArgs params) {
        for (SceneTrigger trigger : this.getTriggersByEvent(eventType)) {
            LuaValue condition = null;
            if (trigger.condition != null && !trigger.condition.isEmpty()) {
                condition = (LuaValue)this.getBindings().get(trigger.condition);
            }
            LuaValue ret = LuaValue.TRUE;
            if (condition != null) {
                LuaValue args2 = LuaValue.NIL;
                if (params != null) {
                    args2 = CoerceJavaToLua.coerce(params);
                }
                ret = condition.call(this.getScriptLibLua(), args2);
            }
            if (!((LuaValue)ret).checkboolean()) continue;
            LuaValue action = (LuaValue)this.getBindings().get(trigger.action);
            action.call(this.getScriptLibLua(), LuaValue.NIL);
        }
    }
}

