/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.plugin.api;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.server.dispatch.DispatchServer;
import emu.grasscutter.server.game.GameServer;
import java.util.LinkedList;
import java.util.List;

public final class ServerHook {
    private static ServerHook instance;
    private final GameServer gameServer;
    private final DispatchServer dispatchServer;

    public static ServerHook getInstance() {
        return instance;
    }

    public ServerHook(GameServer gameServer, DispatchServer dispatchServer) {
        this.gameServer = gameServer;
        this.dispatchServer = dispatchServer;
        instance = this;
    }

    public GameServer getGameServer() {
        return this.gameServer;
    }

    public DispatchServer getDispatchServer() {
        return this.dispatchServer;
    }

    public List<Player> getOnlinePlayers() {
        return new LinkedList<Player>(this.gameServer.getPlayers().values());
    }

    public void registerCommand(CommandHandler handler) {
        Class<?> clazz = handler.getClass();
        if (!clazz.isAnnotationPresent(Command.class)) {
            throw new IllegalArgumentException("Command handler must be annotated with @Command.");
        }
        Command commandData = clazz.getAnnotation(Command.class);
        this.gameServer.getCommandMap().registerCommand(commandData.label(), handler);
    }
}

