/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.plugin;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.plugin.PluginIdentifier;
import emu.grasscutter.plugin.api.ServerHook;
import emu.grasscutter.server.game.GameServer;
import java.io.File;
import java.io.InputStream;
import java.net.URLClassLoader;

public abstract class Plugin {
    private final ServerHook server = ServerHook.getInstance();
    private PluginIdentifier identifier;
    private URLClassLoader classLoader;
    private File dataFolder;

    private void initializePlugin(PluginIdentifier identifier, URLClassLoader classLoader) {
        if (this.identifier != null) {
            Grasscutter.getLogger().warn(this.identifier.name + " had a reinitialization attempt.");
            return;
        }
        this.identifier = identifier;
        this.classLoader = classLoader;
        this.dataFolder = new File(Grasscutter.getConfig().PLUGINS_FOLDER, identifier.name);
        if (!this.dataFolder.exists() && !this.dataFolder.mkdirs()) {
            Grasscutter.getLogger().warn("Failed to create plugin data folder for " + this.identifier.name);
            return;
        }
    }

    public final PluginIdentifier getIdentifier() {
        return this.identifier;
    }

    public final String getName() {
        return this.identifier.name;
    }

    public final String getDescription() {
        return this.identifier.description;
    }

    public final String getVersion() {
        return this.identifier.version;
    }

    public final GameServer getServer() {
        return this.server.getGameServer();
    }

    public final InputStream getResource(String resourceName) {
        return this.classLoader.getResourceAsStream(resourceName);
    }

    public final File getDataFolder() {
        return this.dataFolder;
    }

    public final ServerHook getHandle() {
        return this.server;
    }

    public void onLoad() {
    }

    public void onEnable() {
    }

    public void onDisable() {
    }
}

