/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.netty;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.netty.KcpServerInitializer;
import io.jpower.kcp.netty.ChannelOptionHelper;
import io.jpower.kcp.netty.UkcpChannelOption;
import io.jpower.kcp.netty.UkcpServerChannel;
import io.netty.bootstrap.UkcpServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.net.InetSocketAddress;

public class KcpServer
extends Thread {
    private EventLoopGroup group;
    private UkcpServerBootstrap bootstrap;
    private ChannelInitializer serverInitializer;
    private InetSocketAddress address;

    public KcpServer(InetSocketAddress address) {
        this.address = address;
        this.setName("Netty Server Thread");
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public ChannelInitializer getServerInitializer() {
        return this.serverInitializer;
    }

    public void setServerInitializer(ChannelInitializer serverInitializer) {
        this.serverInitializer = serverInitializer;
    }

    @Override
    public void run() {
        if (this.getServerInitializer() == null) {
            this.setServerInitializer(new KcpServerInitializer());
        }
        try {
            this.group = new NioEventLoopGroup();
            this.bootstrap = new UkcpServerBootstrap();
            ((UkcpServerBootstrap)((UkcpServerBootstrap)this.bootstrap.group(this.group)).channel(UkcpServerChannel.class)).childHandler(this.getServerInitializer());
            ChannelOptionHelper.nodelay(this.bootstrap, true, 20, 2, true).childOption(UkcpChannelOption.UKCP_MTU, 1200);
            this.onStart();
            ChannelFuture f = this.bootstrap.bind(this.getAddress()).sync();
            this.onStartFinish();
            f.channel().closeFuture().sync();
        }
        catch (Exception exception) {
            Grasscutter.getLogger().error("Unable to start game server.", exception);
        }
        finally {
            this.finish();
        }
    }

    public void onStart() {
    }

    public void onStartFinish() {
    }

    private void finish() {
        try {
            this.group.shutdownGracefully();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Grasscutter.getLogger().info("Game Server closed");
    }
}

