/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.netty;

import emu.grasscutter.Grasscutter;
import io.jpower.kcp.netty.UkcpChannel;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

public abstract class KcpChannel
extends ChannelInboundHandlerAdapter {
    private UkcpChannel kcpChannel;
    private ChannelHandlerContext ctx;
    private boolean isActive;

    public UkcpChannel getChannel() {
        return this.kcpChannel;
    }

    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.kcpChannel = (UkcpChannel)ctx.channel();
        this.ctx = ctx;
        this.isActive = true;
        this.onConnect();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.isActive = false;
        this.onDisconnect();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf data = (ByteBuf)msg;
        this.onMessage(ctx, data);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        this.close();
    }

    protected void send(byte[] data) {
        if (!this.isActive()) {
            return;
        }
        ByteBuf packet = Unpooled.wrappedBuffer(data);
        this.kcpChannel.writeAndFlush(packet);
    }

    public void close() {
        if (this.getChannel() != null) {
            this.getChannel().close();
        }
    }

    protected void logPacket(ByteBuf buf) {
        Grasscutter.getLogger().info("Received: \n" + ByteBufUtil.prettyHexDump(buf));
    }

    protected abstract void onConnect();

    protected abstract void onDisconnect();

    public abstract void onMessage(ChannelHandlerContext var1, ByteBuf var2);
}

