/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.shop;

import com.google.gson.reflect.TypeToken;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.common.ItemParamData;
import emu.grasscutter.data.def.ShopGoodsData;
import emu.grasscutter.game.shop.ShopChestBatchUseTable;
import emu.grasscutter.game.shop.ShopChestTable;
import emu.grasscutter.game.shop.ShopInfo;
import emu.grasscutter.game.shop.ShopTable;
import emu.grasscutter.server.game.GameServer;
import emu.grasscutter.utils.Utils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ShopManager {
    private final GameServer server;
    private final Int2ObjectMap<List<ShopInfo>> shopData;
    private final List<ShopChestTable> shopChestData;
    private final List<ShopChestBatchUseTable> shopChestBatchUseData;
    private static final int REFRESH_HOUR = 4;
    private static final String TIME_ZONE = "Asia/Shanghai";

    public Int2ObjectMap<List<ShopInfo>> getShopData() {
        return this.shopData;
    }

    public List<ShopChestTable> getShopChestData() {
        return this.shopChestData;
    }

    public List<ShopChestBatchUseTable> getShopChestBatchUseData() {
        return this.shopChestBatchUseData;
    }

    public ShopManager(GameServer server) {
        this.server = server;
        this.shopData = new Int2ObjectOpenHashMap<List<ShopInfo>>();
        this.shopChestData = new ArrayList<ShopChestTable>();
        this.shopChestBatchUseData = new ArrayList<ShopChestBatchUseTable>();
        this.load();
    }

    public static int getShopNextRefreshTime(ShopInfo shopInfo) {
        return switch (shopInfo.getShopRefreshType()) {
            case ShopInfo.ShopRefreshType.SHOP_REFRESH_DAILY -> Utils.GetNextTimestampOfThisHour(4, TIME_ZONE, shopInfo.getShopRefreshParam());
            case ShopInfo.ShopRefreshType.SHOP_REFRESH_WEEKLY -> Utils.GetNextTimestampOfThisHourInNextWeek(4, TIME_ZONE, shopInfo.getShopRefreshParam());
            case ShopInfo.ShopRefreshType.SHOP_REFRESH_MONTHLY -> Utils.GetNextTimestampOfThisHourInNextMonth(4, TIME_ZONE, shopInfo.getShopRefreshParam());
            default -> 0;
        };
    }

    private void loadShop() {
        try (FileReader fileReader = new FileReader(Grasscutter.getConfig().DATA_FOLDER + "Shop.json");){
            this.getShopData().clear();
            List banners = (List)Grasscutter.getGsonFactory().fromJson((Reader)fileReader, TypeToken.getParameterized(Collection.class, new Type[]{ShopTable.class}).getType());
            if (banners.size() > 0) {
                for (ShopTable shopTable : banners) {
                    for (ShopInfo cost : shopTable.getItems()) {
                        if (cost.getCostItemList() == null) continue;
                        Iterator<ItemParamData> iterator2 = cost.getCostItemList().iterator();
                        while (iterator2.hasNext()) {
                            ItemParamData ipd = iterator2.next();
                            if (ipd.getId() == 201) {
                                cost.setHcoin(cost.getHcoin() + ipd.getCount());
                                iterator2.remove();
                            }
                            if (ipd.getId() != 203) continue;
                            cost.setMcoin(cost.getMcoin() + ipd.getCount());
                            iterator2.remove();
                        }
                    }
                    this.getShopData().put(shopTable.getShopId(), shopTable.getItems());
                }
                Grasscutter.getLogger().info("Shop data successfully loaded.");
            } else {
                Grasscutter.getLogger().error("Unable to load shop data. Shop data size is 0.");
            }
            if (Grasscutter.getConfig().getGameServerOptions().EnableOfficialShop) {
                GameData.getShopGoodsDataEntries().forEach((k, v) -> {
                    if (!this.getShopData().containsKey((int)k)) {
                        this.getShopData().put((int)k, (List<ShopInfo>)new ArrayList());
                    }
                    for (ShopGoodsData sgd : v) {
                        ShopInfo shopInfo = new ShopInfo(sgd);
                        ((List)this.getShopData().get((int)k)).add(shopInfo);
                    }
                });
            }
        }
        catch (Exception e) {
            Grasscutter.getLogger().error("Unable to load shop data.", e);
        }
    }

    private void loadShopChest() {
        try (FileReader fileReader = new FileReader(Grasscutter.getConfig().DATA_FOLDER + "ShopChest.json");){
            this.getShopChestData().clear();
            List shopChestTableList = (List)Grasscutter.getGsonFactory().fromJson((Reader)fileReader, TypeToken.getParameterized(Collection.class, new Type[]{ShopChestTable.class}).getType());
            if (shopChestTableList.size() > 0) {
                this.getShopChestData().addAll(shopChestTableList);
                Grasscutter.getLogger().info("ShopChest data successfully loaded.");
            } else {
                Grasscutter.getLogger().error("Unable to load ShopChest data. ShopChest data size is 0.");
            }
        }
        catch (Exception e) {
            Grasscutter.getLogger().error("Unable to load ShopChest data.", e);
        }
    }

    private void loadShopChestBatchUse() {
        try (FileReader fileReader = new FileReader(Grasscutter.getConfig().DATA_FOLDER + "ShopChestBatchUse.json");){
            this.getShopChestBatchUseData().clear();
            List shopChestBatchUseTableList = (List)Grasscutter.getGsonFactory().fromJson((Reader)fileReader, TypeToken.getParameterized(Collection.class, new Type[]{ShopChestBatchUseTable.class}).getType());
            if (shopChestBatchUseTableList.size() > 0) {
                this.getShopChestBatchUseData().addAll(shopChestBatchUseTableList);
                Grasscutter.getLogger().info("ShopChestBatchUse data successfully loaded.");
            } else {
                Grasscutter.getLogger().error("Unable to load ShopChestBatchUse data. ShopChestBatchUse data size is 0.");
            }
        }
        catch (Exception e) {
            Grasscutter.getLogger().error("Unable to load ShopChestBatchUse data.", e);
        }
    }

    public synchronized void load() {
        this.loadShop();
        this.loadShopChest();
        this.loadShopChestBatchUse();
    }

    public GameServer getServer() {
        return this.server;
    }
}

