/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.player;

import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Transient;
import emu.grasscutter.GameConstants;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.data.def.AvatarSkillDepotData;
import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.entity.EntityAvatar;
import emu.grasscutter.game.entity.EntityBaseGadget;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.player.TeamInfo;
import emu.grasscutter.game.props.ElementType;
import emu.grasscutter.game.props.EnterReason;
import emu.grasscutter.game.props.FightProperty;
import emu.grasscutter.game.world.World;
import emu.grasscutter.net.packet.BasePacket;
import emu.grasscutter.net.proto.EnterTypeOuterClass;
import emu.grasscutter.net.proto.MotionStateOuterClass;
import emu.grasscutter.server.packet.send.PacketAvatarDieAnimationEndRsp;
import emu.grasscutter.server.packet.send.PacketAvatarFightPropUpdateNotify;
import emu.grasscutter.server.packet.send.PacketAvatarLifeStateChangeNotify;
import emu.grasscutter.server.packet.send.PacketAvatarSkillInfoNotify;
import emu.grasscutter.server.packet.send.PacketAvatarTeamUpdateNotify;
import emu.grasscutter.server.packet.send.PacketChangeAvatarRsp;
import emu.grasscutter.server.packet.send.PacketChangeMpTeamAvatarRsp;
import emu.grasscutter.server.packet.send.PacketChangeTeamNameRsp;
import emu.grasscutter.server.packet.send.PacketChooseCurAvatarTeamRsp;
import emu.grasscutter.server.packet.send.PacketPlayerEnterSceneNotify;
import emu.grasscutter.server.packet.send.PacketSceneTeamUpdateNotify;
import emu.grasscutter.server.packet.send.PacketSetUpAvatarTeamRsp;
import emu.grasscutter.server.packet.send.PacketWorldPlayerDieNotify;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Entity
public class TeamManager {
    @Transient
    private Player player;
    private Map<Integer, TeamInfo> teams;
    private int currentTeamIndex;
    private int currentCharacterIndex;
    @Transient
    private TeamInfo mpTeam = new TeamInfo();
    @Transient
    private int entityId;
    @Transient
    private final List<EntityAvatar> avatars = new ArrayList<EntityAvatar>();
    @Transient
    private final Set<EntityBaseGadget> gadgets = new HashSet<EntityBaseGadget>();
    @Transient
    private final IntSet teamResonances = new IntOpenHashSet();
    @Transient
    private final IntSet teamResonancesConfig = new IntOpenHashSet();

    public TeamManager() {
    }

    public TeamManager(Player player) {
        this();
        this.player = player;
        this.teams = new HashMap<Integer, TeamInfo>();
        this.currentTeamIndex = 1;
        for (int i2 = 1; i2 <= 4; ++i2) {
            this.teams.put(i2, new TeamInfo());
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public World getWorld() {
        return this.player.getWorld();
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public Map<Integer, TeamInfo> getTeams() {
        return this.teams;
    }

    public TeamInfo getMpTeam() {
        return this.mpTeam;
    }

    public void setMpTeam(TeamInfo mpTeam) {
        this.mpTeam = mpTeam;
    }

    public int getCurrentTeamId() {
        return this.currentTeamIndex;
    }

    private void setCurrentTeamId(int currentTeamIndex) {
        this.currentTeamIndex = currentTeamIndex;
    }

    public int getCurrentCharacterIndex() {
        return this.currentCharacterIndex;
    }

    public void setCurrentCharacterIndex(int currentCharacterIndex) {
        this.currentCharacterIndex = currentCharacterIndex;
    }

    public long getCurrentCharacterGuid() {
        return this.getCurrentAvatarEntity().getAvatar().getGuid();
    }

    public TeamInfo getCurrentTeamInfo() {
        if (this.getPlayer().isInMultiplayer()) {
            return this.getMpTeam();
        }
        return this.getTeams().get(this.currentTeamIndex);
    }

    public TeamInfo getCurrentSinglePlayerTeamInfo() {
        return this.getTeams().get(this.currentTeamIndex);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public Set<EntityBaseGadget> getGadgets() {
        return this.gadgets;
    }

    public IntSet getTeamResonances() {
        return this.teamResonances;
    }

    public IntSet getTeamResonancesConfig() {
        return this.teamResonancesConfig;
    }

    public List<EntityAvatar> getActiveTeam() {
        return this.avatars;
    }

    public EntityAvatar getCurrentAvatarEntity() {
        return this.getActiveTeam().get(this.currentCharacterIndex);
    }

    public boolean isSpawned() {
        return this.getPlayer().getScene() != null && this.getPlayer().getScene().getEntities().containsKey(this.getCurrentAvatarEntity().getId());
    }

    public int getMaxTeamSize() {
        if (this.getPlayer().isInMultiplayer()) {
            int max2 = Grasscutter.getConfig().getGameServerOptions().MaxAvatarsInTeamMultiplayer;
            if (this.getPlayer().getWorld().getHost() == this.getPlayer()) {
                return Math.max(1, (int)Math.ceil((double)max2 / (double)this.getWorld().getPlayerCount()));
            }
            return Math.max(1, (int)Math.floor((double)max2 / (double)this.getWorld().getPlayerCount()));
        }
        return Grasscutter.getConfig().getGameServerOptions().MaxAvatarsInTeam;
    }

    private void updateTeamResonances() {
        Int2IntOpenHashMap map = new Int2IntOpenHashMap();
        this.getTeamResonances().clear();
        this.getTeamResonancesConfig().clear();
        for (EntityAvatar entity : this.getActiveTeam()) {
            AvatarSkillDepotData skillData = entity.getAvatar().getAvatarData().getSkillDepot();
            if (skillData == null) continue;
            map.addTo(skillData.getElementType().getValue(), 1);
        }
        for (Int2IntMap.Entry e : map.int2IntEntrySet()) {
            ElementType element;
            if (e.getIntValue() < 2 || (element = ElementType.getTypeByValue(e.getIntKey())).getTeamResonanceId() == 0) continue;
            this.getTeamResonances().add(element.getTeamResonanceId());
            this.getTeamResonancesConfig().add(element.getConfigHash());
        }
        if (this.getTeamResonances().size() == 0) {
            this.getTeamResonances().add(ElementType.Default.getTeamResonanceId());
            this.getTeamResonancesConfig().add(ElementType.Default.getTeamResonanceId());
        }
    }

    public void updateTeamEntities(BasePacket responsePacket) {
        if (this.getCurrentTeamInfo().getAvatars().size() <= 0) {
            return;
        }
        EntityAvatar currentEntity = this.getCurrentAvatarEntity();
        Int2ObjectOpenHashMap<EntityAvatar> existingAvatars = new Int2ObjectOpenHashMap<EntityAvatar>();
        int prevSelectedAvatarIndex = -1;
        for (EntityAvatar entity : this.getActiveTeam()) {
            existingAvatars.put(entity.getAvatar().getAvatarId(), entity);
        }
        this.getActiveTeam().clear();
        for (int i2 = 0; i2 < this.getCurrentTeamInfo().getAvatars().size(); ++i2) {
            int avatarId = this.getCurrentTeamInfo().getAvatars().get(i2);
            EntityAvatar entity = null;
            if (existingAvatars.containsKey(avatarId)) {
                entity = (EntityAvatar)existingAvatars.get(avatarId);
                existingAvatars.remove(avatarId);
                if (entity == currentEntity) {
                    prevSelectedAvatarIndex = i2;
                }
            } else {
                entity = new EntityAvatar(this.getPlayer().getScene(), this.getPlayer().getAvatars().getAvatarById(avatarId));
            }
            this.getActiveTeam().add(entity);
        }
        for (EntityAvatar entity : existingAvatars.values()) {
            this.getPlayer().getScene().removeEntity(entity);
            entity.getAvatar().save();
        }
        if (prevSelectedAvatarIndex == -1) {
            prevSelectedAvatarIndex = Math.min(this.currentCharacterIndex, this.getActiveTeam().size() - 1);
        }
        this.currentCharacterIndex = prevSelectedAvatarIndex;
        this.updateTeamResonances();
        this.getPlayer().getWorld().broadcastPacket(new PacketSceneTeamUpdateNotify(this.getPlayer()));
        for (EntityAvatar entity : this.getActiveTeam()) {
            if (entity.getAvatar().getSkillExtraChargeMap().size() <= 0) continue;
            this.getPlayer().sendPacket(new PacketAvatarSkillInfoNotify(entity.getAvatar()));
        }
        if (responsePacket != null) {
            this.getPlayer().sendPacket(responsePacket);
        }
        if (currentEntity != this.getCurrentAvatarEntity()) {
            this.getPlayer().getScene().replaceEntity(currentEntity, this.getCurrentAvatarEntity());
        }
    }

    public synchronized void setupAvatarTeam(int teamId, List<Long> list) {
        if (list.size() == 0 || list.size() > this.getMaxTeamSize() || this.getPlayer().isInMultiplayer()) {
            return;
        }
        TeamInfo teamInfo = this.getTeams().get(teamId);
        if (teamInfo == null) {
            return;
        }
        LinkedHashSet<Avatar> newTeam = new LinkedHashSet<Avatar>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Avatar avatar = this.getPlayer().getAvatars().getAvatarByGuid(list.get(i2));
            if (avatar == null || newTeam.contains(avatar)) {
                return;
            }
            newTeam.add(avatar);
        }
        teamInfo.getAvatars().clear();
        for (Avatar avatar : newTeam) {
            teamInfo.addAvatar(avatar);
        }
        this.getPlayer().sendPacket(new PacketAvatarTeamUpdateNotify(this.getPlayer()));
        if (teamId == this.getCurrentTeamId()) {
            this.updateTeamEntities(new PacketSetUpAvatarTeamRsp(this.getPlayer(), teamId, teamInfo));
        } else {
            this.getPlayer().sendPacket(new PacketSetUpAvatarTeamRsp(this.getPlayer(), teamId, teamInfo));
        }
    }

    public void setupMpTeam(List<Long> list) {
        if (list.size() == 0 || list.size() > this.getMaxTeamSize() || !this.getPlayer().isInMultiplayer()) {
            return;
        }
        TeamInfo teamInfo = this.getMpTeam();
        LinkedHashSet<Avatar> newTeam = new LinkedHashSet<Avatar>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Avatar avatar = this.getPlayer().getAvatars().getAvatarByGuid(list.get(i2));
            if (avatar == null || newTeam.contains(avatar)) {
                return;
            }
            newTeam.add(avatar);
        }
        teamInfo.getAvatars().clear();
        for (Avatar avatar : newTeam) {
            teamInfo.addAvatar(avatar);
        }
        this.updateTeamEntities(new PacketChangeMpTeamAvatarRsp(this.getPlayer(), teamInfo));
    }

    public synchronized void setCurrentTeam(int teamId) {
        if (this.getPlayer().isInMultiplayer()) {
            return;
        }
        TeamInfo teamInfo = this.getTeams().get(teamId);
        if (teamInfo == null || teamInfo.getAvatars().size() == 0) {
            return;
        }
        this.setCurrentTeamId(teamId);
        this.updateTeamEntities(new PacketChooseCurAvatarTeamRsp(teamId));
    }

    public synchronized void setTeamName(int teamId, String teamName) {
        TeamInfo teamInfo = this.getTeams().get(teamId);
        if (teamInfo == null) {
            return;
        }
        teamInfo.setName(teamName);
        this.getPlayer().sendPacket(new PacketChangeTeamNameRsp(teamId, teamName));
    }

    public synchronized void changeAvatar(long guid) {
        EntityAvatar oldEntity = this.getCurrentAvatarEntity();
        if (guid == oldEntity.getAvatar().getGuid()) {
            return;
        }
        EntityAvatar newEntity = null;
        int index = -1;
        for (int i2 = 0; i2 < this.getActiveTeam().size(); ++i2) {
            if (guid != this.getActiveTeam().get(i2).getAvatar().getGuid()) continue;
            index = i2;
            newEntity = this.getActiveTeam().get(i2);
        }
        if (index < 0 || newEntity == oldEntity) {
            return;
        }
        this.setCurrentCharacterIndex(index);
        oldEntity.setMotionState(MotionStateOuterClass.MotionState.MOTION_STANDBY);
        this.getPlayer().getScene().replaceEntity(oldEntity, newEntity);
        this.getPlayer().sendPacket(new PacketChangeAvatarRsp(guid));
    }

    public void onAvatarDie(long dieGuid) {
        EntityAvatar deadAvatar = this.getCurrentAvatarEntity();
        if (deadAvatar.isAlive() || (long)deadAvatar.getId() != dieGuid) {
            return;
        }
        EntityAvatar replacement = null;
        int replaceIndex = -1;
        for (int i2 = 0; i2 < this.getActiveTeam().size(); ++i2) {
            EntityAvatar entity = this.getActiveTeam().get(i2);
            if (!entity.isAlive()) continue;
            replaceIndex = i2;
            replacement = entity;
            break;
        }
        if (replacement == null) {
            this.getPlayer().sendPacket(new PacketWorldPlayerDieNotify(deadAvatar.getKilledType(), deadAvatar.getKilledBy()));
        } else {
            this.setCurrentCharacterIndex(replaceIndex);
            this.getPlayer().getScene().addEntity(replacement);
        }
        this.getPlayer().sendPacket(new PacketAvatarDieAnimationEndRsp((long)deadAvatar.getId(), 0));
    }

    public boolean reviveAvatar(Avatar avatar) {
        for (EntityAvatar entity : this.getActiveTeam()) {
            if (entity.getAvatar() != avatar) continue;
            if (entity.isAlive()) {
                return false;
            }
            entity.setFightProperty(FightProperty.FIGHT_PROP_CUR_HP, entity.getFightProperty(FightProperty.FIGHT_PROP_MAX_HP) * 0.1f);
            this.getPlayer().sendPacket(new PacketAvatarFightPropUpdateNotify(entity.getAvatar(), FightProperty.FIGHT_PROP_CUR_HP));
            this.getPlayer().sendPacket(new PacketAvatarLifeStateChangeNotify(entity.getAvatar()));
            return true;
        }
        return false;
    }

    public boolean healAvatar(Avatar avatar, int healRate, int healAmount) {
        for (EntityAvatar entity : this.getActiveTeam()) {
            if (entity.getAvatar() != avatar) continue;
            if (!entity.isAlive()) {
                return false;
            }
            entity.setFightProperty(FightProperty.FIGHT_PROP_CUR_HP, (float)Math.min((double)entity.getFightProperty(FightProperty.FIGHT_PROP_CUR_HP) + (double)(entity.getFightProperty(FightProperty.FIGHT_PROP_MAX_HP) * (float)healRate) / 100.0 + (double)healAmount / 100.0, (double)entity.getFightProperty(FightProperty.FIGHT_PROP_MAX_HP)));
            this.getPlayer().sendPacket(new PacketAvatarFightPropUpdateNotify(entity.getAvatar(), FightProperty.FIGHT_PROP_CUR_HP));
            this.getPlayer().sendPacket(new PacketAvatarLifeStateChangeNotify(entity.getAvatar()));
            return true;
        }
        return false;
    }

    public void respawnTeam() {
        for (EntityAvatar entity : this.getActiveTeam()) {
            if (!entity.isAlive()) continue;
            return;
        }
        for (EntityAvatar entity : this.getActiveTeam()) {
            entity.setFightProperty(FightProperty.FIGHT_PROP_CUR_HP, entity.getFightProperty(FightProperty.FIGHT_PROP_MAX_HP) * 0.4f);
            this.getPlayer().sendPacket(new PacketAvatarFightPropUpdateNotify(entity.getAvatar(), FightProperty.FIGHT_PROP_CUR_HP));
            this.getPlayer().sendPacket(new PacketAvatarLifeStateChangeNotify(entity.getAvatar()));
        }
        this.getPlayer().sendPacket(new PacketPlayerEnterSceneNotify(this.getPlayer(), EnterTypeOuterClass.EnterType.ENTER_SELF, EnterReason.Revival, 3, GameConstants.START_POSITION));
        this.player.setSceneId(3);
        this.player.getPos().set(GameConstants.START_POSITION);
        this.getPlayer().sendPacket(new BasePacket(222));
    }

    public void saveAvatars() {
        for (EntityAvatar entity : this.getActiveTeam()) {
            entity.getAvatar().save();
        }
    }
}

