/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.player;

import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.IndexOptions;
import dev.morphia.annotations.Indexed;
import dev.morphia.annotations.PostLoad;
import dev.morphia.annotations.Transient;
import emu.grasscutter.GameConstants;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.PlayerLevelData;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.Account;
import emu.grasscutter.game.CoopRequest;
import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.avatar.AvatarProfileData;
import emu.grasscutter.game.avatar.AvatarStorage;
import emu.grasscutter.game.entity.EntityItem;
import emu.grasscutter.game.entity.GameEntity;
import emu.grasscutter.game.friends.FriendsList;
import emu.grasscutter.game.friends.PlayerProfile;
import emu.grasscutter.game.gacha.PlayerGachaInfo;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.inventory.Inventory;
import emu.grasscutter.game.mail.Mail;
import emu.grasscutter.game.mail.MailHandler;
import emu.grasscutter.game.player.InvokeHandler;
import emu.grasscutter.game.player.PlayerBirthday;
import emu.grasscutter.game.player.TeamManager;
import emu.grasscutter.game.props.ActionReason;
import emu.grasscutter.game.props.PlayerProperty;
import emu.grasscutter.game.shop.ShopLimit;
import emu.grasscutter.game.world.Scene;
import emu.grasscutter.game.world.World;
import emu.grasscutter.net.packet.BasePacket;
import emu.grasscutter.net.proto.AbilityInvokeEntryOuterClass;
import emu.grasscutter.net.proto.CombatInvokeEntryOuterClass;
import emu.grasscutter.net.proto.InteractTypeOuterClass;
import emu.grasscutter.net.proto.MpSettingTypeOuterClass;
import emu.grasscutter.net.proto.OnlinePlayerInfoOuterClass;
import emu.grasscutter.net.proto.PlayerApplyEnterMpResultNotifyOuterClass;
import emu.grasscutter.net.proto.PlayerLocationInfoOuterClass;
import emu.grasscutter.net.proto.PlayerWorldLocationInfoOuterClass;
import emu.grasscutter.net.proto.ProfilePictureOuterClass;
import emu.grasscutter.net.proto.ShowAvatarInfoOuterClass;
import emu.grasscutter.net.proto.SocialDetailOuterClass;
import emu.grasscutter.net.proto.SocialShowAvatarInfoOuterClass;
import emu.grasscutter.server.event.player.PlayerJoinEvent;
import emu.grasscutter.server.event.player.PlayerQuitEvent;
import emu.grasscutter.server.game.GameServer;
import emu.grasscutter.server.game.GameSession;
import emu.grasscutter.server.packet.send.PacketAbilityInvocationsNotify;
import emu.grasscutter.server.packet.send.PacketAvatarAddNotify;
import emu.grasscutter.server.packet.send.PacketAvatarDataNotify;
import emu.grasscutter.server.packet.send.PacketAvatarGainCostumeNotify;
import emu.grasscutter.server.packet.send.PacketAvatarGainFlycloakNotify;
import emu.grasscutter.server.packet.send.PacketCardProductRewardNotify;
import emu.grasscutter.server.packet.send.PacketClientAbilityInitFinishNotify;
import emu.grasscutter.server.packet.send.PacketCombatInvocationsNotify;
import emu.grasscutter.server.packet.send.PacketGadgetInteractRsp;
import emu.grasscutter.server.packet.send.PacketOpenStateUpdateNotify;
import emu.grasscutter.server.packet.send.PacketPlayerApplyEnterMpResultNotify;
import emu.grasscutter.server.packet.send.PacketPlayerDataNotify;
import emu.grasscutter.server.packet.send.PacketPlayerEnterSceneNotify;
import emu.grasscutter.server.packet.send.PacketPlayerLevelRewardUpdateNotify;
import emu.grasscutter.server.packet.send.PacketPlayerPropNotify;
import emu.grasscutter.server.packet.send.PacketPlayerStoreNotify;
import emu.grasscutter.server.packet.send.PacketPrivateChatNotify;
import emu.grasscutter.server.packet.send.PacketScenePlayerLocationNotify;
import emu.grasscutter.server.packet.send.PacketSetNameCardRsp;
import emu.grasscutter.server.packet.send.PacketStoreWeightLimitNotify;
import emu.grasscutter.server.packet.send.PacketUnlockNameCardNotify;
import emu.grasscutter.server.packet.send.PacketWorldPlayerLocationNotify;
import emu.grasscutter.server.packet.send.PacketWorldPlayerRTTNotify;
import emu.grasscutter.utils.DateHelper;
import emu.grasscutter.utils.MessageHandler;
import emu.grasscutter.utils.Position;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Entity(value="players", useDiscriminator=false)
public class Player {
    @Id
    private int id;
    @Indexed(options=@IndexOptions(unique=true))
    private String accountId;
    @Transient
    private Account account;
    private String nickname;
    private String signature;
    private int headImage;
    private int nameCardId = 210001;
    private Position pos;
    private Position rotation;
    private PlayerBirthday birthday;
    private Map<Integer, Integer> properties;
    private Set<Integer> nameCardList;
    private Set<Integer> flyCloakList;
    private Set<Integer> costumeList;
    @Transient
    private long nextGuid = 0L;
    @Transient
    private int peerId;
    @Transient
    private World world;
    @Transient
    private Scene scene;
    @Transient
    private GameSession session;
    @Transient
    private AvatarStorage avatars;
    @Transient
    private Inventory inventory = new Inventory(this);
    @Transient
    private FriendsList friendsList;
    @Transient
    private MailHandler mailHandler;
    @Transient
    private MessageHandler messageHandler;
    private TeamManager teamManager;
    private PlayerGachaInfo gachaInfo;
    private PlayerProfile playerProfile;
    private boolean showAvatar;
    private ArrayList<AvatarProfileData> shownAvatars;
    private Set<Integer> rewardedLevels;
    private ArrayList<ShopLimit> shopLimit;
    private int sceneId;
    private int regionId;
    private int mainCharacterId;
    private boolean godmode;
    private boolean moonCard;
    private Date moonCardStartTime;
    private int moonCardDuration;
    private Set<Date> moonCardGetTimes;
    private List<Integer> showAvatarList;
    private boolean showAvatars;
    @Transient
    private boolean paused;
    @Transient
    private int enterSceneToken;
    @Transient
    private SceneLoadState sceneState;
    @Transient
    private boolean hasSentAvatarDataNotify;
    @Transient
    private long nextSendPlayerLocTime = 0L;
    @Transient
    private final Int2ObjectMap<CoopRequest> coopRequests;
    @Transient
    private final InvokeHandler<CombatInvokeEntryOuterClass.CombatInvokeEntry> combatInvokeHandler;
    @Transient
    private final InvokeHandler<AbilityInvokeEntryOuterClass.AbilityInvokeEntry> abilityInvokeHandler;
    @Transient
    private final InvokeHandler<AbilityInvokeEntryOuterClass.AbilityInvokeEntry> clientAbilityInitFinishHandler;

    @Deprecated
    public Player() {
        this.avatars = new AvatarStorage(this);
        this.friendsList = new FriendsList(this);
        this.mailHandler = new MailHandler(this);
        this.pos = new Position();
        this.rotation = new Position();
        this.properties = new HashMap<Integer, Integer>();
        for (PlayerProperty prop : PlayerProperty.values()) {
            if (prop.getId() < 10000) continue;
            this.properties.put(prop.getId(), 0);
        }
        this.gachaInfo = new PlayerGachaInfo();
        this.nameCardList = new HashSet<Integer>();
        this.flyCloakList = new HashSet<Integer>();
        this.costumeList = new HashSet<Integer>();
        this.setSceneId(3);
        this.setRegionId(1);
        this.sceneState = SceneLoadState.NONE;
        this.coopRequests = new Int2ObjectOpenHashMap<CoopRequest>();
        this.combatInvokeHandler = new InvokeHandler(PacketCombatInvocationsNotify.class);
        this.abilityInvokeHandler = new InvokeHandler(PacketAbilityInvocationsNotify.class);
        this.clientAbilityInitFinishHandler = new InvokeHandler(PacketClientAbilityInitFinishNotify.class);
        this.birthday = new PlayerBirthday();
        this.rewardedLevels = new HashSet<Integer>();
        this.moonCardGetTimes = new HashSet<Date>();
        this.shopLimit = new ArrayList();
        this.messageHandler = null;
    }

    public Player(GameSession session) {
        this();
        this.account = session.getAccount();
        this.accountId = this.getAccount().getId();
        this.session = session;
        this.nickname = "Traveler";
        this.signature = "";
        this.teamManager = new TeamManager(this);
        this.birthday = new PlayerBirthday();
        this.setProperty(PlayerProperty.PROP_PLAYER_LEVEL, 1);
        this.setProperty(PlayerProperty.PROP_IS_SPRING_AUTO_USE, 1);
        this.setProperty(PlayerProperty.PROP_SPRING_AUTO_USE_PERCENT, 50);
        this.setProperty(PlayerProperty.PROP_IS_FLYABLE, 1);
        this.setProperty(PlayerProperty.PROP_IS_TRANSFERABLE, 1);
        this.setProperty(PlayerProperty.PROP_MAX_STAMINA, 24000);
        this.setProperty(PlayerProperty.PROP_CUR_PERSIST_STAMINA, 24000);
        this.setProperty(PlayerProperty.PROP_PLAYER_RESIN, 160);
        this.getFlyCloakList().add(140001);
        this.getNameCardList().add(210001);
        this.getPos().set(GameConstants.START_POSITION);
        this.getRotation().set(0.0f, 307.0f, 0.0f);
        this.messageHandler = null;
    }

    public int getUid() {
        return this.id;
    }

    public void setUid(int id) {
        this.id = id;
    }

    public long getNextGameGuid() {
        long nextId = ++this.nextGuid;
        return ((long)this.getUid() << 32) + nextId;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
        this.account.setPlayerId(this.getUid());
    }

    public GameSession getSession() {
        return this.session;
    }

    public void setSession(GameSession session) {
        this.session = session;
    }

    public boolean isOnline() {
        return this.getSession() != null && this.getSession().isActive();
    }

    public GameServer getServer() {
        return this.getSession().getServer();
    }

    public synchronized World getWorld() {
        return this.world;
    }

    public synchronized void setWorld(World world) {
        this.world = world;
    }

    public synchronized Scene getScene() {
        return this.scene;
    }

    public synchronized void setScene(Scene scene) {
        this.scene = scene;
    }

    public int getGmLevel() {
        return 1;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickName) {
        this.nickname = nickName;
        this.updateProfile();
    }

    public int getHeadImage() {
        return this.headImage;
    }

    public void setHeadImage(int picture) {
        this.headImage = picture;
        this.updateProfile();
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
        this.updateProfile();
    }

    public Position getPos() {
        return this.pos;
    }

    public Position getRotation() {
        return this.rotation;
    }

    public int getLevel() {
        return this.getProperty(PlayerProperty.PROP_PLAYER_LEVEL);
    }

    public int getExp() {
        return this.getProperty(PlayerProperty.PROP_PLAYER_EXP);
    }

    public int getWorldLevel() {
        return this.getProperty(PlayerProperty.PROP_PLAYER_WORLD_LEVEL);
    }

    public void setWorldLevel(int level) {
        this.setProperty(PlayerProperty.PROP_PLAYER_WORLD_LEVEL, level);
        this.sendPacket(new PacketPlayerPropNotify(this, PlayerProperty.PROP_PLAYER_WORLD_LEVEL));
    }

    public int getPrimogems() {
        return this.getProperty(PlayerProperty.PROP_PLAYER_HCOIN);
    }

    public void setPrimogems(int primogem) {
        this.setProperty(PlayerProperty.PROP_PLAYER_HCOIN, primogem);
        this.sendPacket(new PacketPlayerPropNotify(this, PlayerProperty.PROP_PLAYER_HCOIN));
    }

    public int getMora() {
        return this.getProperty(PlayerProperty.PROP_PLAYER_SCOIN);
    }

    public void setMora(int mora) {
        this.setProperty(PlayerProperty.PROP_PLAYER_SCOIN, mora);
        this.sendPacket(new PacketPlayerPropNotify(this, PlayerProperty.PROP_PLAYER_SCOIN));
    }

    public int getCrystals() {
        return this.getProperty(PlayerProperty.PROP_PLAYER_MCOIN);
    }

    public void setCrystals(int crystals) {
        this.setProperty(PlayerProperty.PROP_PLAYER_MCOIN, crystals);
        this.sendPacket(new PacketPlayerPropNotify(this, PlayerProperty.PROP_PLAYER_MCOIN));
    }

    private int getExpRequired(int level) {
        PlayerLevelData levelData = (PlayerLevelData)GameData.getPlayerLevelDataMap().get(level);
        return levelData != null ? levelData.getExp() : 0;
    }

    private float getExpModifier() {
        return Grasscutter.getConfig().getGameServerOptions().getGameRates().ADVENTURE_EXP_RATE;
    }

    public void earnExp(int exp2) {
        this.addExpDirectly((int)((float)exp2 * this.getExpModifier()));
    }

    public void addExpDirectly(int gain) {
        boolean hasLeveledUp = false;
        int level = this.getLevel();
        int exp2 = this.getExp();
        int reqExp = this.getExpRequired(level);
        exp2 += gain;
        while (exp2 >= reqExp && reqExp > 0) {
            exp2 -= reqExp;
            reqExp = this.getExpRequired(++level);
            hasLeveledUp = true;
        }
        if (hasLeveledUp) {
            this.setProperty(PlayerProperty.PROP_PLAYER_LEVEL, level);
            this.updateProfile();
            this.sendPacket(new PacketPlayerPropNotify(this, PlayerProperty.PROP_PLAYER_LEVEL));
        }
        this.setProperty(PlayerProperty.PROP_PLAYER_EXP, exp2);
        this.sendPacket(new PacketPlayerPropNotify(this, PlayerProperty.PROP_PLAYER_EXP));
    }

    private void updateProfile() {
        this.getProfile().syncWithCharacter(this);
    }

    public boolean isFirstLoginEnterScene() {
        return !this.hasSentAvatarDataNotify;
    }

    public TeamManager getTeamManager() {
        return this.teamManager;
    }

    public PlayerGachaInfo getGachaInfo() {
        return this.gachaInfo;
    }

    public PlayerProfile getProfile() {
        if (this.playerProfile == null) {
            this.playerProfile = new PlayerProfile(this);
        }
        return this.playerProfile;
    }

    public Map<Integer, Integer> getProperties() {
        return this.properties;
    }

    public void setProperty(PlayerProperty prop, int value) {
        this.getProperties().put(prop.getId(), value);
    }

    public int getProperty(PlayerProperty prop) {
        return this.getProperties().get(prop.getId());
    }

    public Set<Integer> getFlyCloakList() {
        return this.flyCloakList;
    }

    public Set<Integer> getCostumeList() {
        return this.costumeList;
    }

    public Set<Integer> getNameCardList() {
        return this.nameCardList;
    }

    public MpSettingTypeOuterClass.MpSettingType getMpSetting() {
        return MpSettingTypeOuterClass.MpSettingType.MP_SETTING_ENTER_AFTER_APPLY;
    }

    public synchronized Int2ObjectMap<CoopRequest> getCoopRequests() {
        return this.coopRequests;
    }

    public InvokeHandler<CombatInvokeEntryOuterClass.CombatInvokeEntry> getCombatInvokeHandler() {
        return this.combatInvokeHandler;
    }

    public InvokeHandler<AbilityInvokeEntryOuterClass.AbilityInvokeEntry> getAbilityInvokeHandler() {
        return this.abilityInvokeHandler;
    }

    public InvokeHandler<AbilityInvokeEntryOuterClass.AbilityInvokeEntry> getClientAbilityInitFinishHandler() {
        return this.clientAbilityInitFinishHandler;
    }

    public AvatarStorage getAvatars() {
        return this.avatars;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public FriendsList getFriendsList() {
        return this.friendsList;
    }

    public MailHandler getMailHandler() {
        return this.mailHandler;
    }

    public int getEnterSceneToken() {
        return this.enterSceneToken;
    }

    public void setEnterSceneToken(int enterSceneToken) {
        this.enterSceneToken = enterSceneToken;
    }

    public int getNameCardId() {
        return this.nameCardId;
    }

    public void setNameCardId(int nameCardId) {
        this.nameCardId = nameCardId;
        this.updateProfile();
    }

    public int getMainCharacterId() {
        return this.mainCharacterId;
    }

    public void setMainCharacterId(int mainCharacterId) {
        this.mainCharacterId = mainCharacterId;
    }

    public int getPeerId() {
        return this.peerId;
    }

    public void setPeerId(int peerId) {
        this.peerId = peerId;
    }

    public int getClientTime() {
        return this.session.getClientTime();
    }

    public long getLastPingTime() {
        return this.session.getLastPingTime();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean newPauseState) {
        boolean oldPauseState = this.paused;
        this.paused = newPauseState;
        if (newPauseState && !oldPauseState) {
            this.onPause();
        } else if (oldPauseState && !newPauseState) {
            this.onUnpause();
        }
    }

    public SceneLoadState getSceneLoadState() {
        return this.sceneState;
    }

    public void setSceneLoadState(SceneLoadState sceneState) {
        this.sceneState = sceneState;
    }

    public boolean isInMultiplayer() {
        return this.getWorld() != null && this.getWorld().isMultiplayer();
    }

    public int getSceneId() {
        return this.sceneId;
    }

    public void setSceneId(int sceneId) {
        this.sceneId = sceneId;
    }

    public int getRegionId() {
        return this.regionId;
    }

    public void setRegionId(int regionId) {
        this.regionId = regionId;
    }

    public void setShowAvatars(boolean showAvatars) {
        this.showAvatars = showAvatars;
    }

    public boolean isShowAvatars() {
        return this.showAvatars;
    }

    public void setShowAvatarList(List<Integer> showAvatarList) {
        this.showAvatarList = showAvatarList;
    }

    public List<Integer> getShowAvatarList() {
        return this.showAvatarList;
    }

    public boolean inMoonCard() {
        return this.moonCard;
    }

    public void setMoonCard(boolean moonCard) {
        this.moonCard = moonCard;
    }

    public void addMoonCardDays(int days) {
        this.moonCardDuration += days;
    }

    public int getMoonCardDuration() {
        return this.moonCardDuration;
    }

    public void setMoonCardDuration(int moonCardDuration) {
        this.moonCardDuration = moonCardDuration;
    }

    public Date getMoonCardStartTime() {
        return this.moonCardStartTime;
    }

    public void setMoonCardStartTime(Date moonCardStartTime) {
        this.moonCardStartTime = moonCardStartTime;
    }

    public Set<Date> getMoonCardGetTimes() {
        return this.moonCardGetTimes;
    }

    public void setMoonCardGetTimes(Set<Date> moonCardGetTimes) {
        this.moonCardGetTimes = moonCardGetTimes;
    }

    public int getMoonCardRemainDays() {
        Calendar remainCalendar = Calendar.getInstance();
        remainCalendar.setTime(this.moonCardStartTime);
        remainCalendar.add(5, this.moonCardDuration);
        Date theLastDay = remainCalendar.getTime();
        Date now = DateHelper.onlyYearMonthDay(new Date());
        return (int)((theLastDay.getTime() - now.getTime()) / 86400000L);
    }

    public void rechargeMoonCard() {
        this.inventory.addItem(new GameItem(203, 300));
        if (!this.moonCard) {
            this.moonCard = true;
            Date now = new Date();
            this.moonCardStartTime = DateHelper.onlyYearMonthDay(now);
            this.moonCardDuration = 30;
        } else {
            this.moonCardDuration += 30;
        }
        if (!this.moonCardGetTimes.contains(this.moonCardStartTime)) {
            this.moonCardGetTimes.add(this.moonCardStartTime);
        }
    }

    public void getTodayMoonCard() {
        if (!this.moonCard) {
            return;
        }
        Date now = DateHelper.onlyYearMonthDay(new Date());
        if (this.moonCardGetTimes.contains(now)) {
            return;
        }
        Date stopTime = new Date();
        Calendar stopCalendar = Calendar.getInstance();
        stopCalendar.setTime(stopTime);
        stopCalendar.add(5, this.moonCardDuration);
        stopTime = stopCalendar.getTime();
        if (now.after(stopTime)) {
            this.moonCard = false;
            return;
        }
        this.moonCardGetTimes.add(now);
        this.addMoonCardDays(1);
        GameItem item = new GameItem(201, 90);
        this.getInventory().addItem(item, ActionReason.BlessingRedeemReward);
        this.session.send(new PacketCardProductRewardNotify(this.getMoonCardRemainDays()));
    }

    public List<ShopLimit> getShopLimit() {
        return this.shopLimit;
    }

    public ShopLimit getGoodsLimit(int goodsId) {
        Optional<ShopLimit> shopLimit = this.shopLimit.stream().filter(x -> x.getShopGoodId() == goodsId).findFirst();
        if (shopLimit.isEmpty()) {
            return null;
        }
        return shopLimit.get();
    }

    public void addShopLimit(int goodsId, int boughtCount, int nextRefreshTime) {
        ShopLimit target = this.getGoodsLimit(goodsId);
        if (target != null) {
            target.setHasBought(target.getHasBought() + boughtCount);
            target.setHasBoughtInPeriod(target.getHasBoughtInPeriod() + boughtCount);
            target.setNextRefreshTime(nextRefreshTime);
        } else {
            ShopLimit sl = new ShopLimit();
            sl.setShopGoodId(goodsId);
            sl.setHasBought(boughtCount);
            sl.setHasBoughtInPeriod(boughtCount);
            sl.setNextRefreshTime(nextRefreshTime);
            this.getShopLimit().add(sl);
        }
        this.save();
    }

    public boolean inGodmode() {
        return this.godmode;
    }

    public void setGodmode(boolean godmode) {
        this.godmode = godmode;
    }

    public boolean hasSentAvatarDataNotify() {
        return this.hasSentAvatarDataNotify;
    }

    public void setHasSentAvatarDataNotify(boolean hasSentAvatarDataNotify) {
        this.hasSentAvatarDataNotify = hasSentAvatarDataNotify;
    }

    public void addAvatar(Avatar avatar) {
        boolean result = this.getAvatars().addAvatar(avatar);
        if (result) {
            this.getAvatars().addStartingWeapon(avatar);
            if (this.hasSentAvatarDataNotify()) {
                avatar.recalcStats();
                this.sendPacket(new PacketAvatarAddNotify(avatar, false));
            }
        }
    }

    public void addFlycloak(int flycloakId) {
        this.getFlyCloakList().add(flycloakId);
        this.sendPacket(new PacketAvatarGainFlycloakNotify(flycloakId));
    }

    public void addCostume(int costumeId) {
        this.getCostumeList().add(costumeId);
        this.sendPacket(new PacketAvatarGainCostumeNotify(costumeId));
    }

    public void addNameCard(int nameCardId) {
        this.getNameCardList().add(nameCardId);
        this.sendPacket(new PacketUnlockNameCardNotify(nameCardId));
    }

    public void setNameCard(int nameCardId) {
        if (!this.getNameCardList().contains(nameCardId)) {
            return;
        }
        this.setNameCardId(nameCardId);
        this.sendPacket(new PacketSetNameCardRsp(nameCardId));
    }

    public void dropMessage(Object message) {
        if (this.messageHandler != null) {
            this.messageHandler.append(message.toString());
            return;
        }
        this.sendPacket(new PacketPrivateChatNotify(99, this.getUid(), message.toString()));
    }

    public void sendMessage(Player sender, Object message) {
        this.sendPacket(new PacketPrivateChatNotify(sender.getUid(), this.getUid(), message.toString()));
    }

    public List<Mail> getAllMail() {
        return this.getMailHandler().getMail();
    }

    public void sendMail(Mail message) {
        this.getMailHandler().sendMail(message);
    }

    public boolean deleteMail(int mailId) {
        return this.getMailHandler().deleteMail(mailId);
    }

    public Mail getMail(int index) {
        return this.getMailHandler().getMailById(index);
    }

    public int getMailId(Mail message) {
        return this.getMailHandler().getMailIndex(message);
    }

    public boolean replaceMailByIndex(int index, Mail message) {
        return this.getMailHandler().replaceMailByIndex(index, message);
    }

    public void interactWith(int gadgetEntityId) {
        GameEntity entity = this.getScene().getEntityById(gadgetEntityId);
        if (entity == null) {
            return;
        }
        if (entity instanceof EntityItem) {
            int dropOwner;
            EntityItem drop = (EntityItem)entity;
            if (!drop.isShare() && (dropOwner = (int)(drop.getGuid() >> 32)) != this.getUid()) {
                return;
            }
            entity.getScene().removeEntity(entity);
            GameItem item = new GameItem(drop.getItemData(), drop.getCount());
            boolean success = this.getInventory().addItem(item, ActionReason.SubfieldDrop);
            if (success) {
                if (!drop.isShare()) {
                    this.sendPacket(new PacketGadgetInteractRsp(drop, InteractTypeOuterClass.InteractType.INTERACT_PICK_ITEM));
                } else {
                    this.getScene().broadcastPacket(new PacketGadgetInteractRsp(drop, InteractTypeOuterClass.InteractType.INTERACT_PICK_ITEM));
                }
            }
        } else {
            entity.getScene().removeEntity(entity);
        }
    }

    public void onPause() {
    }

    public void onUnpause() {
    }

    public void sendPacket(BasePacket packet) {
        if (this.hasSentAvatarDataNotify) {
            this.getSession().send(packet);
        }
    }

    public OnlinePlayerInfoOuterClass.OnlinePlayerInfo getOnlinePlayerInfo() {
        OnlinePlayerInfoOuterClass.OnlinePlayerInfo.Builder onlineInfo = OnlinePlayerInfoOuterClass.OnlinePlayerInfo.newBuilder().setUid(this.getUid()).setNickname(this.getNickname()).setPlayerLevel(this.getLevel()).setMpSettingType(this.getMpSetting()).setNameCardId(this.getNameCardId()).setSignature(this.getSignature()).setProfilePicture(ProfilePictureOuterClass.ProfilePicture.newBuilder().setAvatarId(this.getHeadImage()));
        if (this.getWorld() != null) {
            onlineInfo.setCurPlayerNumInWorld(this.getWorld().getPlayerCount());
        } else {
            onlineInfo.setCurPlayerNumInWorld(1);
        }
        return onlineInfo.build();
    }

    public PlayerBirthday getBirthday() {
        return this.birthday;
    }

    public void setBirthday(int d, int m3) {
        this.birthday = new PlayerBirthday(d, m3);
        this.updateProfile();
    }

    public boolean hasBirthday() {
        return this.birthday.getDay() > 0;
    }

    public Set<Integer> getRewardedLevels() {
        return this.rewardedLevels;
    }

    public void setRewardedLevels(Set<Integer> rewardedLevels) {
        this.rewardedLevels = rewardedLevels;
    }

    public SocialDetailOuterClass.SocialDetail.Builder getSocialDetail() {
        ArrayList<SocialShowAvatarInfoOuterClass.SocialShowAvatarInfo> socialShowAvatarInfoList = new ArrayList<SocialShowAvatarInfoOuterClass.SocialShowAvatarInfo>();
        if (this.isOnline()) {
            if (this.getShowAvatarList() != null) {
                for (int avatarId : this.getShowAvatarList()) {
                    socialShowAvatarInfoList.add(socialShowAvatarInfoList.size(), SocialShowAvatarInfoOuterClass.SocialShowAvatarInfo.newBuilder().setAvatarId(avatarId).setLevel(this.getAvatars().getAvatarById(avatarId).getLevel()).setCostumeId(this.getAvatars().getAvatarById(avatarId).getCostume()).build());
                }
            }
        } else {
            List<Integer> showAvatarList = DatabaseHelper.getPlayerById(this.id).getShowAvatarList();
            AvatarStorage avatars = DatabaseHelper.getPlayerById(this.id).getAvatars();
            avatars.loadFromDatabase();
            if (showAvatarList != null) {
                for (int avatarId : showAvatarList) {
                    socialShowAvatarInfoList.add(socialShowAvatarInfoList.size(), SocialShowAvatarInfoOuterClass.SocialShowAvatarInfo.newBuilder().setAvatarId(avatarId).setLevel(avatars.getAvatarById(avatarId).getLevel()).setCostumeId(avatars.getAvatarById(avatarId).getCostume()).build());
                }
            }
        }
        SocialDetailOuterClass.SocialDetail.Builder social = SocialDetailOuterClass.SocialDetail.newBuilder().setUid(this.getUid()).setProfilePicture(ProfilePictureOuterClass.ProfilePicture.newBuilder().setAvatarId(this.getHeadImage())).setNickname(this.getNickname()).setSignature(this.getSignature()).setLevel(this.getLevel()).setBirthday(this.getBirthday().getFilledProtoWhenNotEmpty()).setWorldLevel(this.getWorldLevel()).setNameCardId(this.getNameCardId()).setIsShowAvatar(this.isShowAvatars()).addAllShowAvatarInfoList(socialShowAvatarInfoList).setFinishAchievementNum(0);
        return social;
    }

    public List<ShowAvatarInfoOuterClass.ShowAvatarInfo> getShowAvatarInfoList() {
        boolean shouldRecalc;
        Player player;
        ArrayList<ShowAvatarInfoOuterClass.ShowAvatarInfo> showAvatarInfoList = new ArrayList<ShowAvatarInfoOuterClass.ShowAvatarInfo>();
        if (this.isOnline()) {
            player = this;
            shouldRecalc = false;
        } else {
            player = DatabaseHelper.getPlayerById(this.id);
            player.getAvatars().loadFromDatabase();
            player.getInventory().loadFromDatabase();
            shouldRecalc = true;
        }
        List<Integer> showAvatarList = player.getShowAvatarList();
        AvatarStorage avatars = player.getAvatars();
        if (showAvatarList != null) {
            for (int avatarId : showAvatarList) {
                Avatar avatar = avatars.getAvatarById(avatarId);
                if (shouldRecalc) {
                    avatar.recalcStats();
                }
                showAvatarInfoList.add(avatar.toShowAvatarInfoProto());
            }
        }
        return showAvatarInfoList;
    }

    public PlayerWorldLocationInfoOuterClass.PlayerWorldLocationInfo getWorldPlayerLocationInfo() {
        return PlayerWorldLocationInfoOuterClass.PlayerWorldLocationInfo.newBuilder().setSceneId(this.getSceneId()).setPlayerLoc(this.getPlayerLocationInfo()).build();
    }

    public PlayerLocationInfoOuterClass.PlayerLocationInfo getPlayerLocationInfo() {
        return PlayerLocationInfoOuterClass.PlayerLocationInfo.newBuilder().setUid(this.getUid()).setPos(this.getPos().toProto()).setRot(this.getRotation().toProto()).build();
    }

    public synchronized void onTick() {
        if (this.getLastPingTime() > System.currentTimeMillis() + 60000L) {
            this.getSession().close();
            return;
        }
        Iterator it = this.getCoopRequests().values().iterator();
        while (it.hasNext()) {
            CoopRequest req = (CoopRequest)it.next();
            if (!req.isExpired()) continue;
            req.getRequester().sendPacket(new PacketPlayerApplyEnterMpResultNotify(this, false, PlayerApplyEnterMpResultNotifyOuterClass.PlayerApplyEnterMpResultNotify.Reason.SYSTEM_JUDGE));
            it.remove();
        }
        if (this.getWorld() != null) {
            this.sendPacket(new PacketWorldPlayerRTTNotify(this.getWorld()));
            long time = System.currentTimeMillis();
            if (this.getWorld().isMultiplayer() && this.getScene() != null && time > this.nextSendPlayerLocTime) {
                this.sendPacket(new PacketWorldPlayerLocationNotify(this.getWorld()));
                this.sendPacket(new PacketScenePlayerLocationNotify(this.getScene()));
                this.resetSendPlayerLocTime();
            }
        }
    }

    public void resetSendPlayerLocTime() {
        this.nextSendPlayerLocTime = System.currentTimeMillis() + 5000L;
    }

    @PostLoad
    private void onLoad() {
        this.getTeamManager().setPlayer(this);
    }

    public void save() {
        DatabaseHelper.savePlayer(this);
    }

    public void onLogin() {
        Player exists;
        if (this.getTeamManager() == null) {
            this.teamManager = new TeamManager(this);
        }
        if (this.getProfile().getUid() == 0) {
            this.getProfile().syncWithCharacter(this);
        }
        if ((exists = this.getServer().getPlayerByUid(this.getUid())) != null) {
            exists.getSession().close();
        }
        this.getAvatars().loadFromDatabase();
        this.getInventory().loadFromDatabase();
        this.getAvatars().postLoad();
        this.getFriendsList().loadFromDatabase();
        this.getMailHandler().loadFromDatabase();
        World world = new World(this);
        world.addPlayer(this);
        if (this.getSession().isActive()) {
            this.getServer().registerPlayer(this);
            this.getProfile().setPlayer(this);
        }
        this.setProperty(PlayerProperty.PROP_PLAYER_MP_SETTING_TYPE, this.getMpSetting().getNumber());
        this.setProperty(PlayerProperty.PROP_IS_MP_MODE_AVAILABLE, 1);
        this.session.send(new PacketPlayerDataNotify(this));
        this.session.send(new PacketStoreWeightLimitNotify());
        this.session.send(new PacketPlayerStoreNotify(this));
        this.session.send(new PacketAvatarDataNotify(this));
        this.getTodayMoonCard();
        this.session.send(new PacketPlayerEnterSceneNotify(this));
        this.session.send(new PacketPlayerLevelRewardUpdateNotify(this.rewardedLevels));
        this.session.send(new PacketOpenStateUpdateNotify());
        this.setHasSentAvatarDataNotify(true);
        PlayerJoinEvent event = new PlayerJoinEvent(this);
        event.call();
        if (event.isCanceled()) {
            this.session.close();
        }
    }

    public void onLogout() {
        if (this.getWorld() != null) {
            this.getWorld().removePlayer(this);
        }
        this.getProfile().syncWithCharacter(this);
        this.getProfile().setPlayer(null);
        this.getCoopRequests().clear();
        this.save();
        this.getTeamManager().saveAvatars();
        this.getFriendsList().save();
        PlayerQuitEvent event = new PlayerQuitEvent(this);
        event.call();
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public static enum SceneLoadState {
        NONE(0),
        LOADING(1),
        INIT(2),
        LOADED(3);

        private final int value;

        private SceneLoadState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

