/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.player;

import emu.grasscutter.game.player.Player;
import emu.grasscutter.net.packet.BasePacket;
import emu.grasscutter.net.proto.ForwardTypeOuterClass;
import java.util.ArrayList;
import java.util.List;

public class InvokeHandler<T> {
    private final List<T> entryListForwardAll = new ArrayList<T>();
    private final List<T> entryListForwardAllExceptCur = new ArrayList<T>();
    private final List<T> entryListForwardHost = new ArrayList<T>();
    private final Class<? extends BasePacket> packetClass;

    public InvokeHandler(Class<? extends BasePacket> packetClass) {
        this.packetClass = packetClass;
    }

    public synchronized void addEntry(ForwardTypeOuterClass.ForwardType forward, T entry) {
        switch (forward) {
            case FORWARD_TO_ALL: {
                this.entryListForwardAll.add(entry);
                break;
            }
            case FORWARD_TO_ALL_EXCEPT_CUR: 
            case FORWARD_TO_ALL_EXIST_EXCEPT_CUR: {
                this.entryListForwardAllExceptCur.add(entry);
                break;
            }
            case FORWARD_TO_HOST: {
                this.entryListForwardHost.add(entry);
                break;
            }
        }
    }

    public synchronized void update(Player player) {
        if (player.getWorld() == null) {
            this.entryListForwardAll.clear();
            this.entryListForwardAllExceptCur.clear();
            this.entryListForwardHost.clear();
            return;
        }
        try {
            BasePacket packet;
            if (this.entryListForwardAll.size() > 0) {
                packet = this.packetClass.getDeclaredConstructor(List.class).newInstance(this.entryListForwardAll);
                player.getScene().broadcastPacket(packet);
                this.entryListForwardAll.clear();
            }
            if (this.entryListForwardAllExceptCur.size() > 0) {
                packet = this.packetClass.getDeclaredConstructor(List.class).newInstance(this.entryListForwardAllExceptCur);
                player.getScene().broadcastPacketToOthers(player, packet);
                this.entryListForwardAllExceptCur.clear();
            }
            if (this.entryListForwardHost.size() > 0) {
                packet = this.packetClass.getDeclaredConstructor(List.class).newInstance(this.entryListForwardHost);
                player.getWorld().getHost().sendPacket(packet);
                this.entryListForwardHost.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

